% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_completers.R
\name{cut_date_for_completers}
\alias{cut_date_for_completers}
\title{Find calendar date for target completer count}
\usage{
cut_date_for_completers(data, target_completers)
}
\arguments{
\item{data}{A data frame of simulated data, typically from \code{\link[=nb_sim]{nb_sim()}} or
\code{\link[=nb_sim_seasonal]{nb_sim_seasonal()}}.}

\item{target_completers}{Integer. The target number of completers.}
}
\value{
Numeric. The calendar date when \code{target_completers} is achieved.
If the dataset contains fewer than \code{target_completers} completers, returns the maximum
calendar time in the dataset and prints a message.
}
\description{
Finds the calendar time (since start of randomization) at which a specified
number of subjects have completed their follow-up.
}
\examples{
enroll_rate <- data.frame(rate = 20 / (5 / 12), duration = 5 / 12)
fail_rate <- data.frame(treatment = c("Control", "Experimental"), rate = c(0.5, 0.3))
dropout_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.1, 0.05), duration = c(100, 100)
)
sim <- nb_sim(enroll_rate, fail_rate, dropout_rate, max_followup = 2, n = 20)
cut_date_for_completers(sim, target_completers = 5)
}
