% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unblinded_ssr.R
\name{unblinded_ssr}
\alias{unblinded_ssr}
\title{Unblinded sample size re-estimation for recurrent events}
\usage{
unblinded_ssr(
  data,
  ratio = 1,
  lambda1_planning,
  lambda2_planning,
  rr0 = 1,
  power = 0.8,
  alpha = 0.025,
  accrual_rate,
  accrual_duration,
  trial_duration,
  dropout_rate = 0,
  max_followup = NULL,
  event_gap = NULL
)
}
\arguments{
\item{data}{A data frame containing the unblinded interim data. Must include
columns \code{events} (number of events), \code{tte} (total exposure/follow-up time),
and \code{treatment} (treatment group identifier, e.g., 1 for control, 2 for experimental).
This is typically the output of \code{\link[=cut_data_by_date]{cut_data_by_date()}}.}

\item{ratio}{Planned allocation ratio (experimental / control). Default is 1.}

\item{lambda1_planning}{Planned event rate for the control group used in original calculation.}

\item{lambda2_planning}{Planned event rate for the experimental group used in original calculation.}

\item{rr0}{Rate ratio under the null hypothesis (lambda2/lambda1). Default is 1.}

\item{power}{Target power (1 - beta). Default is 0.8.}

\item{alpha}{One-sided significance level. Default is 0.025.}

\item{accrual_rate}{Vector of accrual rates (patients per unit time).}

\item{accrual_duration}{Vector of durations for each accrual rate. Must be same length
as \code{accrual_rate}.}

\item{trial_duration}{Total planned duration of the trial.}

\item{dropout_rate}{Dropout rate (hazard rate). Default is 0.}

\item{max_followup}{Maximum follow-up time for any patient. Default is NULL (infinite).}

\item{event_gap}{Gap duration after each event during which no new events are counted.
Default is NULL (no gap).}
}
\value{
A list containing:
\describe{
\item{n_total_unblinded}{Re-estimated total sample size using unblinded estimates.}
\item{dispersion_unblinded}{Estimated dispersion parameter (k) from unblinded data.}
\item{lambda1_unblinded}{Estimated control event rate from unblinded data.}
\item{lambda2_unblinded}{Estimated experimental event rate from unblinded data.}
\item{info_fraction}{Estimated information fraction at interim (unblinded information / target information).}
\item{unblinded_info}{Estimated statistical information from the unblinded interim data.}
\item{target_info}{Target statistical information required for the planned power.}
}
}
\description{
Estimates the event rates and dispersion from unblinded interim data
and calculates the required sample size to maintain power, assuming the
planned treatment effect holds (or using the observed control rate).
}
\examples{
interim <- data.frame(
  events = c(1, 2, 1, 3),
  tte = c(0.8, 1.0, 1.2, 0.9),
  treatment = c("Control", "Control", "Experimental", "Experimental")
)
unblinded_ssr(
  interim,
  ratio = 1,
  lambda1_planning = 0.5,
  lambda2_planning = 0.3,
  power = 0.8,
  alpha = 0.025,
  accrual_rate = 10,
  accrual_duration = 12,
  trial_duration = 18
)
}
