\name{simdataExtract}
\alias{simdataExtract}
\title{Extract simulated data for a single trial}
\usage{simdataExtract (simmod, simn, tinterims,
         datanames=c("id", "atime", "catime", "intervention", "outcome"),
         full=FALSE)}
\description{Extract data created using function \code{gsearlySimulate}.}
\arguments{
 \item{simmod}{A simulation model created using function
   \code{\link{gsearlySimulate}}, where full data are available i.e.
   where \code{full=TRUE}.}
 \item{simn}{Simulation number.}
 \item{tinterims}{A vector of ordered numeric valid (i.e. a subset of those in
   \code{simmod}) interim analysis time-points. If unset, these are taken
   from \code{simmod}.}
\item{datanames}{Names of the five required data variables; participant
   identifier, time-point, standardized (continuous) time-point (see
  \code{\link{tfuStandard}}), intervention arm and outcome, in that order;
  e.g. \code{c("id","atime","catime","intervention","outcome"))}.}
 \item{full}{Either \code{FALSE}, which provides a data frame only or
   \code{TRUE} which provides model details in addition to the data frame.}
}
\value{
 A list  containing the following components.
 \item{model}{A list of \code{s}, \code{tinterims}, \code{tfu} and mean,
   covariance and correlation matrices and parameters and sample sizes.}
 \item{data}{A data frame consisting of five columns that are respectively the
   participant id, time-point, standardized time-point, intervention arm and
   outcome, in that order.}
}
\seealso{
 \code{\link{gsearlySimulate}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.2400,0.7200,0.9750)
 modeldesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(18,30), pow=0.9, vphi=0.5, m=2,
                   cmodel="uniform", sd=20, rho=0.5, theta=8, fp=fp, tn=tn)

 # Simulate data from this model with raw data using full=TRUE
 simdata <- gsearlySimulate(mod=modeldesign, nsim=10, full=TRUE)

 # Extract raw data for a single simulation
 simdat1 <- simdataExtract(simdata, simn=1, tinterims=18,
          full=TRUE, datanames=c("ID","Time", "cTime", "Treat", "Outcome"))
 head(simdat1$data,n=20)

}
