% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dctmtx.R
\name{dctmtx}
\alias{dctmtx}
\title{Discrete Cosine Transform Matrix}
\usage{
dctmtx(n)
}
\arguments{
\item{n}{Size of DCT matrix, specified as a positive integer.}
}
\value{
Discrete cosine transform, returned as a vector or matrix.
}
\description{
Compute the discrete cosine transform matrix.
}
\details{
A DCT transformation matrix is useful for doing things like JPEG image
compression, in which an 8x8 DCT matrix is applied to non-overlapping blocks
throughout an image and only a sub-block on the top left of each block is
kept.  During restoration, the remainder of the block is filled with zeros
and the inverse transform is applied to the block.

The two-dimensional DCT of A can be computed as \code{D \%*\% A \%*\% t(D)}.
This computation is sometimes faster than using \code{dct2}, especially if
you are computing a large number of small DCTs, because D needs to be
determined only once. For example, in JPEG compression, the DCT of each
8-by-8 block is computed. To perform this computation, use \code{dctmtx} to
determine D of input image A, and then calculate each DCT using \code{D \%*\%
A \%*\% t(D)} (where A is each 8-by-8 block). This is faster than calling
\code{dct2} for each individual block.
}
\examples{
D <- dctmtx(8)

}
\seealso{
\code{\link{dct}}, \code{\link{dct2}}, \code{\link{idct}},
  \code{\link{idct2}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
