% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/get_significant_single_tissue_eqtls_by_location.R
\name{get_significant_single_tissue_eqtls_by_location}
\alias{get_significant_single_tissue_eqtls_by_location}
\title{Get Significant Single Tissue eQTLs By Location}
\usage{
get_significant_single_tissue_eqtls_by_location(
  tissueSiteDetailId,
  start,
  end,
  chromosome,
  datasetId = "gtex_v8",
  .return_raw = FALSE
)
}
\arguments{
\item{tissueSiteDetailId}{String. The ID of the tissue of interest. Can be a
GTEx specific ID (e.g. "Whole_Blood"; use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}}
to see valid values) or an Ontology ID.}

\item{start}{Integer.}

\item{end}{Integer.}

\item{chromosome}{String. One of "chr1", "chr2", "chr3", "chr4", "chr5",
"chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13",
"chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21",
"chr22", "chrM", "chrX", "chrY".}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Find significant single tissue eQTLs using Chromosomal Locations.
\itemize{
\item This service returns precomputed significant single tissue eQTLs.
\item Results may be filtered by tissue, and/or dataset.
}

By default, the service queries the latest GTEx release. Since this endpoint
is used to support a third party program on the portal, the return structure
is different from other endpoints and is not paginated.

\href{https://gtexportal.org/api/v2/redoc#tag/Static-Association-Endpoints/operation/get_significant_single_tissue_eqtls_api_v2_association_singleTissueEqtl_get}{GTEx Portal API documentation}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_significant_single_tissue_eqtls_by_location(
  tissueSiteDetailId = "Artery_Aorta",
  start = 10000,
  end = 250000,
  chromosome = "chr11"
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Static Association Endpoints: 
\code{\link{get_eqtl_genes}()},
\code{\link{get_fine_mapping}()},
\code{\link{get_independent_eqtl}()},
\code{\link{get_multi_tissue_eqtls}()},
\code{\link{get_significant_single_tissue_eqtls}()},
\code{\link{get_significant_single_tissue_ieqtls}()},
\code{\link{get_significant_single_tissue_isqtls}()},
\code{\link{get_significant_single_tissue_sqtls}()},
\code{\link{get_sqtl_genes}()}
}
\concept{Static Association Endpoints}
