% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_uni_reg.R
\name{stratified_uni_reg}
\alias{stratified_uni_reg}
\title{Performs univariate regression for each exposure on a
binary, count, or continuous outcome,
stratified by a specified variable. Produces a stacked `gtsummary`
table with one column per stratum,
along with underlying models and diagnostics.}
\usage{
stratified_uni_reg(data, outcome, exposures, stratifier, approach = "logit")
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{outcome}{name of the outcome variable.}

\item{exposures}{A vector specifying the predictor (exposure) variables.}

\item{stratifier}{A character string specifying the stratifier}

\item{approach}{Modeling approach to use. One of:
`"logit"` (Odds Ratios), `"log-binomial"` (Risk Ratios),
`"poisson"` (Incidence Rate Ratios), `"robpoisson"` (Robust RR),
 `"linear"` (Beta coefficients), `"negbin"` (Incidence Rate Ratios),.}
}
\value{
An object of class `stratified_uni_reg`, which includes:
- `table`: A `gtsummary::tbl_stack` object with stratified results,
- `models`: A list of fitted models for each stratum,
- `model_summaries`: A tidy list of model summaries,
- `reg_check`: A tibble of regression diagnostics (when available).
}
\description{
Performs univariate regression for each exposure on a
binary, count, or continuous outcome,
stratified by a specified variable. Produces a stacked `gtsummary`
table with one column per stratum,
along with underlying models and diagnostics.
}
\section{Accessors}{

\describe{
  \item{\code{$table}}{Stacked stratified regression table.}
  \item{\code{$models}}{List of fitted model objects for each stratum.}
  \item{\code{$model_summaries}}{List of tidy model summaries.}
  \item{\code{$reg_check}}{Diagnostic check results (when applicable).}
}
}

\examples{
if (requireNamespace("mlbench", quietly = TRUE) &&
  requireNamespace("dplyr", quietly = TRUE)) {
  data(PimaIndiansDiabetes2, package = "mlbench")
  pima <- dplyr::mutate(
    PimaIndiansDiabetes2,
    diabetes = ifelse(diabetes == "pos", 1, 0),
    glucose_cat = dplyr::case_when(
      glucose < 140 ~ "Normal",
      glucose >= 140 ~ "High"
    )
  )
  stratified_uni <- stratified_uni_reg(
    data = pima,
    outcome = "diabetes",
    exposures = c("age", "mass"),
    stratifier = "glucose_cat",
    approach = "logit"
  )
  stratified_uni$table
}

}
\seealso{
[multi_reg()], [plot_reg()], [identify_confounder()]
}
