% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gwas2crispr.R
\name{run_gwas2crispr}
\alias{run_gwas2crispr}
\title{Run the GWAS to CRISPR export pipeline (hg38)}
\usage{
run_gwas2crispr(
  efo_id,
  p_cut = 5e-08,
  flank_bp = 200,
  out_prefix = NULL,
  genome_pkg = "BSgenome.Hsapiens.UCSC.hg38",
  verbose = interactive()
)
}
\arguments{
\item{efo_id}{character. Experimental Factor Ontology (EFO) identifier,
e.g., "EFO_0001663".}

\item{p_cut}{numeric. P-value threshold for significance (default 5e-8).}

\item{flank_bp}{integer. Flanking bases for FASTA sequences (default 200).}

\item{out_prefix}{character or NULL. File prefix (including path) for outputs.
If \code{NULL} (default), nothing is written to disk and a result object is returned.
To write files safely in examples/tests, use \code{file.path(tempdir(), "prefix")}.}

\item{genome_pkg}{character. BSgenome package to use for FASTA
(default "BSgenome.Hsapiens.UCSC.hg38"); FASTA step is skipped if not installed.}

\item{verbose}{logical. If TRUE, emit progress via \code{message()}.}
}
\value{
(Invisibly) a list with elements:
\itemize{
\item \code{summary}: tibble with basic counts.
\item \code{snps_full}: tibble of SNP metadata.
\item \code{bed}: tibble of BED intervals (if computed).
\item \code{fasta}: \code{Biostrings::DNAStringSet} (if computed).
\item \code{written}: character vector of file paths written (possibly empty).
}
}
\description{
End-to-end pipeline: fetch significant associations, annotate,
and optionally write CSV/BED/FASTA outputs. By default no files are written;
set \code{out_prefix} to write results.
}
\details{
Network I/O may occur when fetching data. Only GRCh38/hg38 is supported.
}
\examples{
\donttest{
  # Write into a temporary directory so we don't touch the user's filespace:
  tmp <- tempdir()
  res <- run_gwas2crispr(
    efo_id     = "EFO_0001663",
    p_cut      = 5e-8,
    flank_bp   = 200,
    out_prefix = file.path(tmp, "prostate"),
    verbose    = FALSE
  )

  # If you omit 'out_prefix', nothing is written; an object is returned:
  res2 <- run_gwas2crispr(
    efo_id     = "EFO_0001663",
    p_cut      = 5e-8,
    flank_bp   = 200,
    out_prefix = NULL,
    verbose    = FALSE
  )
}

}
\seealso{
\code{\link{fetch_gwas}}
}
