% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{bind}
\alias{bind}
\title{Bind GWAS Catalog objects}
\usage{
bind(x, ...)
}
\arguments{
\item{x}{An object of class: \linkS4class{studies},
\linkS4class{associations}, \linkS4class{variants}, or
\linkS4class{traits}.}

\item{...}{Objects of the same class as \code{x}.}
}
\value{
An object of the same class as \code{x}.
}
\description{
Binds together GWAS Catalog objects of the same class. Note that
\code{bind()} preserves duplicates whereas
\code{\link[gwasrapidd:setop]{union}} does not.
}
\examples{
# Join two studies objects.
bind(studies_ex01, studies_ex02)

# Join two associations objects.
bind(associations_ex01, associations_ex02)

# Join two variants objects.
bind(variants_ex01, variants_ex02)

# Join two traits objects.
bind(traits_ex01, traits_ex02)

}
