% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize.r
\name{h5_delete}
\alias{h5_delete}
\title{Delete an HDF5 Object or Attribute}
\usage{
h5_delete(file, name, attr = NULL, warn = TRUE)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the object to delete (e.g., \code{"/data/dset"} or \code{"/groups/g1"}).}

\item{attr}{The name of the attribute to delete.
\itemize{
\item If \code{NULL} (the default), the object specified by \code{name} is deleted.
\item If a string is provided, the attribute named \code{attr} is removed from the object \code{name}.
}}

\item{warn}{Emit a warning if the name/attr does not exist. Default: \code{TRUE}}
}
\value{
Invisibly returns \code{NULL}. This function is called for its side effects.
}
\description{
Deletes an object (dataset or group) or an attribute from an HDF5 file.
If the object or attribute does not exist, a warning is issued and the function returns
successfully (no error is raised).
}
\examples{
file <- tempfile(fileext = ".h5")
h5_create_file(file)

# Create some data and attributes
h5_write(matrix(1:10, 2, 5), file, "matrix")
h5_write("A note", file, "matrix", attr = "note")

# Review the file structure
h5_str(file)

# Delete the attribute
h5_delete(file, "matrix", attr = "note")

# Review the file structure
h5_str(file)

# Delete the dataset
h5_delete(file, "matrix")

# Review the file structure
h5_str(file)

# Cleaning up
unlink(file)
}
\seealso{
\code{\link[=h5_create_group]{h5_create_group()}}, \code{\link[=h5_move]{h5_move()}}
}
