% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hNMF.R
\name{hNMF}
\alias{hNMF}
\title{Hierarchical non-negative matrix factorization.}
\usage{
hNMF(nmfInput, nmfMethod = "HALSacc")
}
\arguments{
\item{nmfInput}{List with NMF input attributes}

\item{nmfMethod}{String referring to the NMF algorithm to be used.}
}
\value{
Resulting NMF model (in accordance with NMF package definition)
}
\description{
Hierarchical non-negative matrix factorization.
}
\examples{

# create nmfInput object
X <- matrix(runif(10*20), 10,20)
bgImageTensor <- array(0,dim=dim(X))
selectVect <- array(1,dim=dim(X))
nmfInput <- NULL
nmfInput$numRows <- nrow(X)
nmfInput$numCols <- ncol(X)
nmfInput$numSlices <- 1
nmfInput$bgImageTensor <- bgImageTensor
nmfInput$selectVect <- selectVect

# run NMF with default algorithm, 5 runs with random initialization
NMFresult1 <- oneLevelNMF(X, rank=2, nruns=5)

# run NMF with specified algorithm and with initialized sources
W0 <- initializeSPA(X,3)
NMFresult2 <- oneLevelNMF(X, rank=3, method="HALSacc", initData = W0)
}
\author{
Nicolas Sauwen
}
