% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{wrapper - s and summary funs}
\alias{wrapper - s and summary funs}
\alias{max_}
\alias{sum_}
\alias{mean_}
\alias{min_}
\alias{sd_}
\alias{var_}
\alias{first_}
\alias{last_}
\alias{median_}
\alias{first_non_na}
\alias{squeeze}
\alias{squeeze_}
\title{Combine aggregate functions and s}
\usage{
max_(.x, ignore_na = TRUE)

min_(.x, ignore_na = TRUE)

sum_(.x, ignore_na = TRUE)

mean_(.x, ignore_na = TRUE)

median_(.x, ignore_na = TRUE)

sd_(.x, ignore_na = TRUE)

var_(.x, ignore_na = TRUE)

first_(.x, ignore_na = TRUE)

last_(.x, ignore_na = TRUE)

first_non_na(.x)

squeeze(.x, ignore_na = FALSE)

squeeze_(.x, ignore_na = TRUE)
}
\arguments{
\item{.x}{a single vector}

\item{ignore_na}{if false missing values are not omitted.}
}
\value{
a single aggregated value
}
\description{
\code{[summary function_*]} functions are simple wrappers of aggregate function
and the \code{s} function. \code{s} removes all non-values,
i.e. \code{NA,Inf,NaN}  from a vector.
However, if the length is 0 it returns NA. The result is then passed to the
corresponding aggregation function. For example,
\code{min_(x)} is identical to \code{min(s(x))}. Please read \code{vignette("s")} for more information.
}
\details{
'first_non_na' is a faster version of 'first' since it only search for a non NA value until it finds one.
'squeeze' on the other hand checks if all elements are equal and then returns only that value.
}
\examples{
## sum_ on non-rational numeric vector
vector <- c(7, NaN, -Inf, 4)
sum_(vector)

## Min of vector with length 0
vector <- c()
# With a wrapped s
min_(vector)

## Max of vector with only NA
# With a wrapped s
max_(vector)

## Use of s when NA should not be removed
vector <- c(7, Inf, NA, 4)
# With a wrapped s
sum_(vector, ignore_na = FALSE)

}
\seealso{
\code{vignette("convert")}, \code{vignette("hablar")}
}
