% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smv.R
\name{smv}
\alias{smv}
\title{Calculate second moment of volume}
\usage{
smv(mesh, axis = "z", scale = FALSE, origin = TRUE)
}
\arguments{
\item{mesh}{A triangular mesh of class mesh3d.}

\item{axis}{The axis along which to calculate the second moment of volume z is the default.}

\item{scale}{Logical. Scale the object to have a volume = 1? Default = FALSE}

\item{origin}{Logical. Set the origin to the bottom left corner of bounding box? Default = TRUE}
}
\value{
SMV value.
}
\description{
Calculates the 2nd moment of volume (SMV) by multiplying the volume of each
triangle in the mesh by its centroids' distance from the origin (should be set to the attachment point
of the mesh). The sum of these values is the 2nd moment of volume.
Axis is z by default, meaning it will calculate the vertical second moment, but this can be changed if needed.
This metric is size-dependent so to compare moments in terms of shape only, set scale = TRUE.
}
\examples{
smv(mcap)
}
