% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hal.R
\name{num_knots_generator}
\alias{num_knots_generator}
\title{A default generator for the \code{num_knots} argument for each degree of
interactions and the smoothness orders.}
\usage{
num_knots_generator(
  max_degree,
  smoothness_orders,
  base_num_knots_0 = 500,
  base_num_knots_1 = 200
)
}
\arguments{
\item{max_degree}{interaction degree.}

\item{smoothness_orders}{see \code{\link{fit_hal}}.}

\item{base_num_knots_0}{The base number of knots for zeroth-order smoothness
basis functions. The number of knots by degree interaction decays as
\code{base_num_knots_0/2^(d-1)} where \code{d} is the interaction degree of the basis
function.}

\item{base_num_knots_1}{The base number of knots for 1 or greater order
smoothness basis functions. The number of knots by degree interaction
decays as \code{base_num_knots_1/2^(d-1)} where \code{d} is the interaction degree of
the basis function.}
}
\description{
A default generator for the \code{num_knots} argument for each degree of
interactions and the smoothness orders.
}
\keyword{internal}
