% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipw_shift.R
\name{ipw_shift}
\alias{ipw_shift}
\title{IPW Estimator of the Causal Effects of Additive Modified Treatment Policies}
\usage{
ipw_shift(
  W,
  A,
  Y,
  delta = 0,
  n_bins = make_bins(A, "hist"),
  cv_folds = 10L,
  lambda_seq,
  ...,
  bin_type = c("equal_range", "equal_mass"),
  selector_type = c("dcar", "plateau", "gcv", "all")
)
}
\arguments{
\item{W}{A \code{matrix}, \code{data.frame}, or similar containing a set of
baseline covariates.}

\item{A}{A \code{numeric} vector corresponding to a exposure variable. The
parameter of interest is defined as a location shift of this quantity.}

\item{Y}{A \code{numeric} vector of the observed outcomes.}

\item{delta}{A \code{numeric} value indicating the shift in the exposure to
be used in defining the target parameter. This is defined with respect to
the scale of the exposure (A).}

\item{n_bins}{A \code{numeric}, scalar or vector, indicating the number of
bins into which the support of A is to be partitioned for constructing
conditional density estimates.}

\item{cv_folds}{A \code{numeric} giving the number of folds to be used for
cross-validation. Note that this form of sample splitting is used for the
selection of tuning parameters by empirical risk minimization, not for the
estimation of nuisance parameters (i.e., to relax regularity conditions).}

\item{lambda_seq}{A \code{numeric} sequence of the regularization parameter
(L1 norm of HAL coefficients) to be used in fitting HAL models.}

\item{...}{Additional arguments for model fitting to be passed directly to
\code{\link{haldensify}}.}

\item{bin_type}{A \code{character} indicating the strategy to be used in
creating bins along the observed support of \code{A}. For bins of equal
range, use \code{"equal_range"}; to ensure each bin has the same number of
observations, use instead \code{"equal_mass"}. For more information, see
documentation of \code{grid_type} in \code{\link{haldensify}}.}

\item{selector_type}{A \code{character} indicating the selection strategy
for identifying an efficent IPW estimator. The choices include \code{"gcv"}
for global cross-validation, \code{"dcar"} for solving the EIF equation,
and \code{"plateau"} for agnostic approaches (1) balancing changes in the
IPW estimate and its standard error (adapting Lepski's method) and (2) a
plateau detector for inflection points in the IPW estimator's trajectory.
The option \code{"all"} runs all three selection strategies while sharing
redundant computation between each.}
}
\description{
IPW Estimator of the Causal Effects of Additive Modified Treatment Policies
}
\examples{
# simulate data
set.seed(11249)
n_obs <- 50
W1 <- rbinom(n_obs, 1, 0.6)
W2 <- rbinom(n_obs, 1, 0.2)
W3 <- rpois(n_obs, 3)
A <- rpois(n_obs, 3 * W1 - W2 + 2 * W1 * W2 + 4)
Y <- rbinom(n_obs, 1, plogis(A + W1 + W2 - W3 - W1 * W3))

# fit the IPW estimator
est_ipw <- ipw_shift(
  W = cbind(W1, W2, W3), A = A, Y = Y,
  delta = 0.5, cv_folds = 3L,
  n_bins = 4L, bin_type = "equal_range",
  lambda_seq = exp(seq(-1, -10, length = 100L)),
  # arguments passed to hal9001::fit_hal()
  max_degree = 1L,
  smoothness_orders = 0,
  reduce_basis = 1 / sqrt(n_obs)
)
}
