% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{haversine}
\alias{haversine}
\title{Calculate the haversine distance in kilometers given lat/lon pairs}
\usage{
haversine(lat1, lon1, lat2, lon2)
}
\arguments{
\item{lat1}{A vector of latitudes}

\item{lon1}{A vector of longitudes}

\item{lat2}{A vector of latitudes}

\item{lon2}{A vector of longitudes}
}
\value{
a vector of distances in kilometers
}
\description{
Calculate the haversine distance in kilometers given lat/lon pairs
}
\examples{
# simple haversine calculation 
lon1 <- runif(-160, -60, n = 10e6)
lat1 <- runif(40, 60, n = 10e6)
lon2 <- runif(-160, -60, n = 10e6)
lat2 <- runif(40, 60, n = 10e6)
df <- data.frame(lat1, lon1, lat2, lon2)
df$havers <- haversine(df$lat1, df$lon1, df$lat2, df$lon2)
}
