% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mad.R
\name{mad}
\alias{mad}
\title{Compute variable-wise mean absolute differences (MAD) between original and imputed dataframes.}
\usage{
mad(original, imputed, round)
}
\arguments{
\item{original}{A data frame or tibble with original values.}

\item{imputed}{A data frame or tibble that has been imputed/completed.}

\item{round}{Integer. Number of places to round MAD scores. Default set to 3.}
}
\value{
`mad_scores` as `p` x 2 tibble. One row for each variable in \code{original}, from 1 to `p`. Two columns: first is variable names (`var`) and second is associated MAD score (`mad`) as percentages for each variable.
}
\description{
Compute variable-wise mean absolute differences (MAD) between original and imputed dataframes.
}
\examples{
\dontrun{
mad(original = original_data, imputed = imputed_data, round = 3)
}
}
