% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo.R
\name{censo_estimativa}
\alias{censo_estimativa}
\title{Get intercensitary population estimates}
\usage{
censo_estimativa(
  year,
  territorial_level = "state",
  geo_code = "all",
  raw = FALSE
)
}
\arguments{
\item{year}{Numeric or vector. Year(s) between 2001 and 2021.}

\item{territorial_level}{Character. Geographic level:
\code{"brazil"}, \code{"region"}, \code{"state"}, or \code{"municipality"}.
Default is \code{"state"}.}

\item{geo_code}{Character. IBGE code(s) for specific localities.
\code{"all"} returns all localities at the chosen level. Default is \code{"all"}.}

\item{raw}{Logical. If TRUE, returns raw API output without cleaning.
Default is FALSE.}
}
\value{
A tibble with population estimates.
}
\description{
Retrieves population estimates for intercensitary years (2001-2021) from
SIDRA table 6579. These estimates provide population denominators for years
between censuses.
}
\details{
Table 6579 provides total population estimates (no sex/age breakdown).
These estimates are published annually by IBGE and are widely used as
denominators for health indicator calculations.

For census years with full demographic breakdowns, use
\code{\link{censo_populacao}} instead.
}
\section{Data source}{

Data is retrieved from IBGE SIDRA API, table 6579:
\verb{https://sidra.ibge.gov.br/tabela/6579}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# estimates for 2020 by state
censo_estimativa(year = 2020)

# estimates for multiple years, Brazil level
censo_estimativa(year = 2015:2020, territorial_level = "brazil")

# estimates by municipality
censo_estimativa(year = 2021, territorial_level = "municipality")
\dontshow{\}) # examplesIf}
}
