% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daly.R
\name{daly}
\alias{daly}
\title{Attributable disability-adjusted life years}
\usage{
daly(output_attribute_yll, output_attribute_yld)
}
\arguments{
\item{output_attribute_yll, output_attribute_yld}{\code{variable} containing YLL or YLD results of a \code{attribute_...()} function call, respectively.}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the main results;
\itemize{
 \item \code{impact} (\code{numeric} column) attributable health burden/impact in DALY
 \item \code{impact_yld} (\code{numeric} column) attributable health burden/impact in YLD
 \item \code{impact_yll} (\code{numeric} column) attributable health burden/impact in YLL
 \item \code{dw} (\code{numeric} column) disability weight used for YLD calculation
 \item And many more
 }

2) \code{health_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{results_raw} (\code{tibble}) containing results for each combination of input uncertainty
 \item \code{results_by_geo_id_micro} (\code{tibble}) containing results for each geographic unit under analysis (specified in \code{geo_id_micro} argument)
 \item \code{input_args} (\code{list}) containing all the argument inputs used in the background
 }
}
\description{
This function quantifies the attributable disability-adjusted life years (DALY)
by summing the two DALY components:
years of life lost (YLL) and years lived with disability (YLD).
}
\details{
\strong{Methodology}

This function sums the years of life lost (YLL) and years lived with disability (YLD)
to obtain the disability-adjusted lost years (DALY) \insertCite{GBD2020_tl}{healthiar}.

Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#dalys}{dalys}}
}
\examples{
# Goal: obtain DALY (disability-adjusted life years) from two existing \code{attribute_...} outputs
# Step 1: Create YLL (years of life lost) assessment
results_yll <- attribute_lifetable(
  health_outcome = "yll",
  approach_exposure = "single_year",
  approach_newborns = "without_newborns",
  exp_central = 8.85,
  prop_pop_exp = 1,
  cutoff_central = 5,
  rr_central =  1.118,
  rr_increment = 10,
  erf_shape = "log_linear",
  age_group = exdat_lifetable$age_group,
  sex = exdat_lifetable$sex,
  bhd_central = exdat_lifetable$deaths,
  population = exdat_lifetable$midyear_population,
  year_of_analysis = 2019,
  min_age = 20
)
# Step 2: Create YLD (years lived with disability) assessment
results_yld  <- attribute_health(
  exp_central = 8.85,
  prop_pop_exp = 1,
  cutoff_central = 5,
  bhd_central = 1000,
  rr_central = 1.1,
  rr_increment = 10,
  erf_shape = "log_linear",
  duration_central = 100,
  dw_central = 0.5,
  info = "pm2.5_yld"
)
# Step 3: obtain DALY
results <- daly(
  output_attribute_yll = results_yll,
  output_attribute_yld = results_yld
)
# Attributable impact in DALY
results$health_main |>
  dplyr::select(impact, impact_yll, impact_yld)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream: \code{\link{attribute_health}}, \code{\link{attribute_lifetable}}
}
}
\author{
Alberto Castro & Axel Luyten
}
