% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Stepping_df}
\alias{Stepping_df}
\title{Stepping and Heart Rate}
\format{
A data frame with 30 observations and 6 variables:
\describe{
  \item{Order}{Numeric vector indicating the order of the measurement.}
  \item{Block}{Numeric vector indicating the block or session number.}
  \item{Height}{Factor with 2 levels indicating step height (1 = Low, 2 = High).}
  \item{Freq}{Factor with 3 levels indicating stepping frequency (1 = Slow, 2 = Medium, 3 = Fast).}
  \item{HRInit}{Numeric vector indicating the subject's heart rate before the trial (beats per minute).}
  \item{HRFinal}{Numeric vector indicating the subject's heart rate after the trial (beats per minute).}
}
}
\source{
Data taken from the sur package version 1.0.4.
}
\usage{
data(Stepping_df)
}
\description{
This dataset, Stepping_df, is a data frame containing heart rate measurements of
subjects performing stepping exercises at different heights and frequencies. Each
subject's resting heart rate was measured before a trial (HRInit) and after stepping
(HRFinal). Step heights include 5.75 inches (Low) and 11.5 inches (High), and stepping
frequencies include 14 steps/min (Slow), 21 steps/min (Medium), and 28 steps/min (Fast),
resulting in six possible height/frequency combinations. Each trial lasted three minutes,
with subjects kept on pace by an electric metronome and heart rate counted by an experimenter.
}
\details{
The dataset name has been kept as 'Stepping_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
