% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_heart.R
\name{pulse_find_peaks_one_channel}
\alias{pulse_find_peaks_one_channel}
\title{Determine the heart beat frequency in one PULSE channel}
\usage{
pulse_find_peaks_one_channel(split_window_one_channel)
}
\arguments{
\item{split_window_one_channel}{a tibble with PULSE data for only one channel with columns \verb{$time} and \verb{$val}}
}
\value{
A one-row tibble with 8 columns:
\itemize{
\item \code{time},  time at the center of split_window_one_channel$time
\item \code{t_pks}, time stamps of each wave peak identified
\item \code{hz},    heartbeat rate estimate (in Hz)
\item \code{n},     number of wave peaks identified
\item \code{sd},    standard deviation of the intervals between wave peaks
\item \code{ci},    confidence interval (hz ± ci)
}
}
\description{
Take data from one PULSE channel and identify the heartbeat wave peaks using an algorithm that searches for maxima across multiple scales.
}
\details{
function builds upon code from https://github.com/ig248/pyampd
}
\section{Standard Deviation}{

The \code{sd} computed refers to the spread of the intervals between each peak identified. It is a measure of the quality of the raw data and the ability of the algorithm to identify a real heart beat. The lower the \code{sd}, the more regular are the intervals between peaks, and the more likely that the algorithm did find a real signal. Conversely, higher \code{sd}s indicate that the peaks are found at irregular intervals, and is an indication of poor quality data.
In detail, \code{sd} is computed by: 1) taking the timestamps for each peak identified [\code{t_pks}], 2) computing the intervals between each pair of consecutive peaks [\code{as.numeric(diff(t_pks))}], and 3) computing \code{sd} [\code{sd(intervals)}].
}

\section{BPM}{

To convert to Beats Per Minute, simply multiply \code{hz} and \code{ci} by 60.
}

\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:5]
pulse_data_split <- pulse_split(pulse_data_sub)
pulse_data_split <- pulse_optimize(pulse_data_split, multi = pulse_data$multi)
split_window <- pulse_data_split$data[[1]]
split_window_one_channel <- split_window[,1:2]
colnames(split_window_one_channel) <- c("time", "val")
# End prepare data ----

## Determine heartbeat rates in one channel in one time window
pulse_find_peaks_one_channel(split_window_one_channel)
}
\seealso{
\itemize{
\item \code{\link[=pulse_find_peaks_all_channels]{pulse_find_peaks_all_channels()}} runs \code{\link[=pulse_find_peaks_one_channel]{pulse_find_peaks_one_channel()}} on all PULSE channels
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_heart]{pulse_heart()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
