% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_optimize.R
\name{pulse_optimize}
\alias{pulse_optimize}
\title{(\verb{STEP 3}) Optimize PULSE data through interpolation and smoothing}
\usage{
pulse_optimize(
  pulse_data_split,
  interpolation_freq = 40,
  bandwidth = 0.2,
  raw_v_smoothed = FALSE,
  multi
)
}
\arguments{
\item{pulse_data_split}{the output from a call to \code{\link[=pulse_split]{pulse_split()}}}

\item{interpolation_freq}{numeric, defautls to \code{40}; value expressing the frequency (in Hz) to which PULSE data should be interpolated. Can be set to \code{0} (zero) or any value equal or greater than \code{40} (the default). If set to zero, no interpolation is performed.}

\item{bandwidth}{numeric, defaults to \code{0.2}; the bandwidth for the Kernel Regression Smoother. If equal to \code{0} (zero) no smoothing is applied. Normally kept low (\code{0.1 - 0.3}) so that only very high frequency noise is removed, but can be pushed up all the way to \code{1} or above (especially when the heartbeat rate is expected to be slow, as is typical of oysters, but double check the resulting data). Type \code{?ksmooth} for additional info.}

\item{raw_v_smoothed}{logical, defaults to \code{FALSE}; if set to \code{FALSE}, the output includes only one list obtained after applying interpolation and smoothing according to the values set. If set to \code{TRUE}, a list with two lists is returned, one after applying only interpolation (i.e., "raw"), and the other after applying both interpolation and smoothing (i.e, "smoothed").}

\item{multi}{logical; was the data  generated by a multi-channel system (\code{TRUE}) or a one-channel system (\code{FALSE})?}
}
\value{
The same structure as the input data, which is a tibble with three columns, but now with the values on column $\code{smoothed} switched to \code{TRUE} if smoothing was applied and the contents of column $\code{data} modified in accordance with the parameters called. If \code{raw_v_smoothed} is \code{FALSE}, the tibble returned will have the same number of rows as the input tibble. If \code{raw_v_smoothed} is \code{TRUE}, the tibble returned will have twice the number of rows as the input tibble, with half not smoothed (i.e., only interpolation applied), the other half smoothed (i.e., interpolation and smoothing applied) and the order indexes in $\code{i} duplicated. Downstream functions will process both types of output automatically.
}
\description{
\itemize{
\item \verb{step 1} -- \code{\link[=pulse_read]{pulse_read()}}
\item \verb{step 2} -- \code{\link[=pulse_split]{pulse_split()}}
\item \strong{\verb{-->>} step 3 -- \code{\link[=pulse_optimize]{pulse_optimize()}} \verb{<<--}}
\item \verb{step 4} -- \code{\link[=pulse_heart]{pulse_heart()}}
\item \verb{step 5} -- \code{\link[=pulse_doublecheck]{pulse_doublecheck()}}
\item \verb{step 6} -- \code{\link[=pulse_choose_keep]{pulse_choose_keep()}}
}

IMPORTANT NOTE: \code{pulse_optimize()} can be skipped, but that is highly discouraged.

The performance of the algorithm employed in the downstream function \code{pulse_heart()} for the detection of heartbeat wave crests depends significantly on \code{(i)} there being a sufficient number of data points around each crest and \code{(ii)} the data not being too noisy. \code{pulse_optimize()} uses first \code{pulse_interpolate()} and then \code{pulse_smooth()} to reshape the data and improve the likelihood of \code{pulse_heart()} successfully estimating the inherent heartbeat rates.
\itemize{
\item \code{INTERPOLATION} is highly recommended because tests on real data have shown that a frequency of at least 40 Hz is crucial to ensure wave crests can be discerned even when the underlying heartbeat rate is high (i.e., at rates above 2-3 Hz). Since the PULSE multi-channel system is not designed to capture data at such high rates (partially because it would generate files unnecessarily large), \code{pulse_interpolate()} is used instead to artificially increase the temporal resolution of the data by linearly interpolating to the target frequency. It is important to note that this process DOES NOT ALTER the shape of the heart beat wave, it just introduces intermediary data points. Also, the only downside to using very high values for \code{interpolation_freq} is the proportional increase in computing time and size of the outputs together with minimal improvements in the performance of \code{pulse_heart()} - but no artefacts are expected.
\item \code{SMOOTHING} should be experimented with when \code{pulse_heart()} produces too many heartbeat rate estimates that are clearly incorrect. In such situations, \code{pulse_smooth()} applies a smoothing filter (normal Kernel Regression Smoother) to the data to smooth out high-frequency noise and render a more sinusoidal wave, which is easier to handle. Unlike \code{interpolation_freq}, users should exercise caution when setting \code{bandwidth} and generally opt for lower values, as there's a threshold to bandwidth values above which the resulting smoothed pulse data becomes completely unrelated to the original data, and the subsequent heartbeat rates computed with \code{pulse_heart()} may be wrong. Always double-check the data after applying a stronger smoothing. Nonetheless, note that if applied with the default \code{bandwidth}, smoothing incurs no penalty and hardly changes the data - so it isn't worth going out of the way to not apply smoothing.
}
}
\section{Raw v smoothed}{

When \code{raw_v_smoothed} is set to \code{TRUE}, two heart rate estimates are produced for each data point - one based on the raw data and another after applying smoothing. The cost is an increase in processing time. The benefit is an improvement in the ability to estimate heart rates when the heart is beating faster, as in those cases smoothing the data may become counterproductive. When \code{raw_v_smoothed = TRUE}, \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} will decide which of the estimates to retain for each data point (based on user-defined parameters).
}

\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:5]
pulse_data_split <- pulse_split(pulse_data_sub)
## End prepare data ----

# Optimize data by interpolating to 40 Hz and applying a slight smoothing
pulse_optimize(pulse_data_split, 40, 0.2, multi = pulse_data$multi)
}
\seealso{
\itemize{
\item \code{\link[=approx]{approx()}} is used by \code{\link[=pulse_interpolate]{pulse_interpolate()}} for the linear interpolation of PULSE data
\item \code{\link[=ksmooth]{ksmooth()}} is used by \code{\link[=pulse_smooth]{pulse_smooth()}} for the kernel smoothing of PULSE data
\item \code{\link[=pulse_optimize]{pulse_optimize()}} is a wrapper function that executes \code{\link[=pulse_interpolate]{pulse_interpolate()}} and \code{\link[=pulse_smooth]{pulse_smooth()}} sequentially
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_heart]{pulse_heart()}}, \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} and \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
