% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.frame.heckmanGE.R
\name{model.frame.heckmanGE}
\alias{model.frame.heckmanGE}
\title{model.frame.heckmanGE
Get the Model Frames of a Generalized Heckman Regression}
\usage{
\method{model.frame}{heckmanGE}(
  formula,
  part = c("selection", "outcome", "dispersion", "correlation"),
  ...
)
}
\arguments{
\item{formula}{An object of class \code{heckmanGE}. This object should be a fitted model from which the model frames will be extracted.}

\item{part}{A character vector specifying the model part for which to extract the model frame. Options include "selection", "outcome", "dispersion", and "correlation". The default is "outcome". If multiple parts are specified, only the "outcome" part will be returned.}

\item{\dots}{Additional arguments passed to or from other methods. These are not used in this method but must be included to match the generic method signature.}
}
\value{
A model frame for the specified part of the \code{heckmanGE} object. If \code{part} is not one of the valid options, an error is raised.
}
\description{
Extracts the model frames for different parts of a \code{heckmanGE} model. The model frames include the data used in the regression analysis for each component of the Generalized Heckman Model.
}
\details{
\itemize{
\item The function extracts the model frame corresponding to the specified part of the \code{heckmanGE} model.
\item If the \code{part} argument is not specified correctly or includes multiple parts, the function defaults to returning the model frame for the "outcome" part.
}
}
