% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.heckmange.R
\name{predict.heckmanGE}
\alias{predict.heckmanGE}
\title{predict.heckmanGE
Predictions from the Generalized Heckman Model}
\usage{
\method{predict}{heckmanGE}(
  object,
  ...,
  part = c("selection", "outcome", "dispersion", "correlation"),
  newdata = NULL,
  type = c("link", "response"),
  cofint = FALSE,
  confidence_level = 0.95
)
}
\arguments{
\item{object}{An object of class \code{heckmanGE}. This object should be a fitted model from which predictions will be made.}

\item{\dots}{Argumentos adicionais passados para métodos específicos. Este argumento é mantido para compatibilidade com a função genérica \code{predict}.}

\item{part}{A character vector specifying the model part for which to make predictions. Options include "selection", "outcome", "dispersion", and "correlation". The default is "outcome". If multiple parts are specified, only the "outcome" part will be used.}

\item{newdata}{Optionally, a data frame containing new data for making predictions. If omitted, the function uses the fitted linear predictors from the model object.}

\item{type}{The type of prediction required. The default is "link", which returns predictions on the scale of the linear predictors. If "response" is specified, predictions are returned on the scale of the response variable after applying the inverse link function.}

\item{cofint}{A logical indicating whether to return confidence intervals for the predictions. Default is FALSE.}

\item{confidence_level}{A numeric value specifying the confidence level for the confidence intervals if \code{cofint} is TRUE. Default is 0.95.}
}
\value{
A vector or matrix of predictions from the \code{heckmanGE} object, depending on the value of \code{cofint}. If \code{cofint} is TRUE, the function returns a matrix with the mean predicted value, and the lower and upper bounds of the confidence interval.
}
\description{
Generates predictions from a fitted \code{heckmanGE} model. Predictions can be made on the scale of the linear predictors or on the scale of the response variable. The function can also return confidence intervals for the predictions if requested.
}
\details{
\itemize{
\item The function first checks the validity of the \code{part} and \code{type} arguments.
\item If \code{newdata} is provided, the function ensures it matches the variables and structure of the original model frame.
\item Predictions can be on the link scale or the response scale, depending on the \code{type} argument.
\item Confidence intervals are calculated if \code{cofint} is TRUE, using the standard errors derived from the model.
}
}
