% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_pattern.R
\name{import_pattern}
\alias{import_pattern}
\title{Quickly import plaintext files.}
\usage{
import_pattern(filepath)
}
\arguments{
\item{filepath}{A valid character string to the plaintext file containing
the pattern.}
}
\value{
A character string, typically used to assemble a draft.
}
\description{
Longer, multi-chunk patterns can benefit from being developed in files
independent of the rest of a draft. This is a quick wrapper function to
import those patterns as objects for assembly into a draft.
}
\examples{
pattern_file <- tempfile("out", tempdir(), ".Rmd")
export_template("my sample pattern", pattern_file)
import_pattern(pattern_file)
}
\seealso{
Other import functions: 
\code{\link{extract_draft}()},
\code{\link{extract_pattern}()},
\code{\link{import_draft}()}
}
\concept{import functions}
