#' HEI-2020 Scoring Standards
#'
#' A table outlining the criteria for achieving the maximum HEI score in each of the 13 components for individuals ages 2 years or older.
#'
#' @format ## `HEI_scoring_standards`
#' A data frame with 13 rows and 6 columns:
#' \describe{
#'   \item{component}{HEI Component}
#'   \item{max_points}{The maximum number of points alloted to the HEI component}
#'   \item{max_amount}{The amount of the HEI component required to earn a maximum component score}
#'   \item{zero_score}{The amount of the HEI component that would earn 0 points towards the component score}
#'   \item{unit}{The HEI component's unit of measurement}
#'   \item{component_type}{Whether the HEI component is an 'adequacy' or 'moderation' type}
#' }
#' @source <https://www.fns.usda.gov/cnpp/how-hei-scored>
"HEI_scoring_standards"
