% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipsoid.R
\name{Ellipsoid}
\alias{Ellipsoid}
\alias{Ellipsoid.data.frame}
\alias{Ellipsoid.default}
\title{Draw an Ellipsoid in an rgl Scene}
\usage{
Ellipsoid(x, ...)

\method{Ellipsoid}{data.frame}(x, which = 1:3, method = c("classical", "mve", "mcd"), ...)

\method{Ellipsoid}{default}(
  x,
  center = c(0, 0, 0),
  which = 1:3,
  radius = 1,
  df = Inf,
  label = "",
  cex.label = 1.5,
  col = "pink",
  lwd = 1,
  segments = 40,
  shade = TRUE,
  alpha = 0.1,
  wire = TRUE,
  verbose = FALSE,
  warn.rank = FALSE,
  ...
)
}
\arguments{
\item{x}{An object. In the default method the parameter x should be a square positive definite matrix at               least 3x3 in size. It will be treated as the correlation or covariance of a multivariate normal
distribution. For the \code{data.frame} method, it should be a numeric data frame with at
least 3 columns.}

\item{...}{Other arguments}

\item{which}{This parameter selects which variables from the object will be plotted. The default is the first 3.}

\item{method}{the covariance method to be used: classical product-moment (\code{"classical"}),
or minimum volume ellipsoid (\code{"mve"}), or
minimum covariance determinant (\code{"mcd"}}

\item{center}{center of the ellipsoid, a vector of length 3, typically the mean vector of data}

\item{radius}{size of the ellipsoid}

\item{df}{degrees of freedom associated with the covariance matrix, used to calculate the appropriate F statistic}

\item{label}{label for the ellipsoid}

\item{cex.label}{text size of label}

\item{col}{color of the ellipsoid}

\item{lwd}{line with for the wire-frame version}

\item{segments}{number of segments composing each ellipsoid; defaults to \code{40}.}

\item{shade}{logical; should the ellipsoid be smoothly shaded?}

\item{alpha}{transparency of the shaded ellipsoid}

\item{wire}{logical; should the ellipsoid be drawn as a wire frame?}

\item{verbose}{logical; for debugging}

\item{warn.rank}{logical; warn if the ellipsoid is less than rank 3?}
}
\value{
returns the bounding box of the ellipsoid invisibly; otherwise used for it's side effect of
drawing the ellipsoid
}
\description{
This is an experimental function designed to separate internal code in \code{link{heplot3d}}.
}
\examples{
# none yet
}
