% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametise.R
\name{H2_Delta_parameters}
\alias{H2_Delta_parameters}
\alias{h2_Delta_parameters}
\title{Calculate heritability of pairwise differences using variance parameters}
\usage{
h2_Delta_parameters(G_g, vd_matrix, type)

H2_Delta_parameters(vc_g, vd_matrix, type)
}
\arguments{
\item{vc_g}{Numeric. Genotype variance component}

\item{vd_matrix}{Matrix. Variance of pairwise differences among BLUES or BLUPs}

\item{type}{Character. Either BLUES or BLUPS used to compute the variance of pairwise differences.}

\item{G_g}{Numeric. Genotypic variance-covariance matrix.}
}
\value{
Matrix of pairwise heritability of differences among BLUES or BLUPs
}
\description{
Compute broad-sense heritability of differences
using the variance of differences between two BLUPs/BLUEs
}
\details{
See \code{\link[=H2_Delta]{H2_Delta()}} and reference for full derivation
and equation for heritability Delta
}
\examples{
h2_Delta_parameters(G_g = diag(0.15, 2, 2), vd_matrix = matrix(c(NA,0.2,0.2,NA),2,2), type = "BLUP")

H2_Delta_parameters(vc_g = 0.01, vd_matrix = matrix(c(NA,0.2,0.2,NA),2,2), "BLUE")

}
\references{
Schmidt, P., Hartung, J., Rath, J., & Piepho, H.-P. (2019). Estimating
Broad-Sense Heritability with Unbalanced Data from Agricultural Cultivar
Trials. Crop Science, 59(2), 525–536. https://doi.org/10.2135/cropsci2018.06.0376
}
