% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{allocq}
\alias{allocq}
\title{Allocation}
\usage{
allocq(w, q)
}
\arguments{
\item{w}{weights}

\item{q}{batch size}
}
\value{
allocation of integer number of runs depending on weights
}
\description{
Allocate replicates based on portfolio weights
}
\details{
proceeds by dichotomy
}
\examples{
set.seed(42)
n <- 10
w <- runif(n)^4
w <- w/sum(w)
q <- 5
al <- allocq(w = w, q = q)
plot(w, pch = 20)
segments(x0 = 1:n, x1 = 1:n, y0 = rep(0, n), y1 = al/10)
# Asynchronous case
q2 <- q + 2
al2 <- allocq(w = w, q = q2)
plot(w, pch = 20, main = "q = 5, q' = 2")
for(i in 1:length(al)){
 if(al[i] > 0){
  for(j in 1:al[i]) arrows(x0 = i, x1 = i, y0 = (j-1)/10, y1 = j/10, code = 3, 
   angle = 90, lwd = 2, length = 0.1)
 }
}
for(i in 1:length(al2)){
 if(al2[i] > 0){
  for(j in 1:al2[i]) arrows(x0 = i + 0.05, x1 = i + 0.05, y0 = (j-1)/10, y1 = j/10,
   code = 3, angle = 90, col = "red", lwd = 2, lty = 2, length = 0.1)
 }
}
}
