% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_hgnc_dataset.R
\name{import_hgnc_dataset}
\alias{import_hgnc_dataset}
\title{Import HGNC data}
\usage{
import_hgnc_dataset(file = latest_archive_url())
}
\arguments{
\item{file}{A file or URL of the complete HGNC data set (in TSV format).
Use \code{\link[=list_archives]{list_archives()}} to list previous versions of these data. Pass one
of the URLs (column \code{url}) to \code{file} to import that specific version. By
default the value of \code{file} is the URL corresponding to the latest version,
i.e. the returned value of \code{\link[=latest_archive_url]{latest_archive_url()}}.}
}
\value{
A \link[tibble:tibble-package]{tibble} of the HGNC data set consisting of
55 columns:
\itemize{
\item \code{hgnc_id}: A unique ID provided by HGNC for each gene with an approved symbol. IDs are of the format \code{'HGNC:n'}, where \code{n} is a unique number. HGNC IDs remain stable even if a name or symbol changes.
\item \code{hgnc_id2}: A stripped down version of \code{hgnc_id} where the prefix \code{'HGNC:'} has been removed. This column is added by the package \code{{hgnc}}.
\item \code{symbol}: The official gene symbol approved by the HGNC, typically a short form of the gene name. Symbols are approved in accordance with the Guidelines for Human Gene Nomenclature.
\item \code{name}: The full gene name approved by the HGNC; corresponds to the approved symbol above.
\item \code{locus_group}: A group name for a set of related locus types as defined by the HGNC. One of: \code{'protein-coding gene'}, \code{'non-coding RNA'}, \code{'pseudogene'} or \code{'other'}.
\item \code{locus_type}: Specifies the genetic class of each gene entry, including various types of RNA and other gene-related categories, such as pseudogenes and virus integration sites.
\item \code{status}: Status of the symbol report, which can be either \code{'Approved'} or \code{'Entry Withdrawn'}.
\item \code{location}: Chromosomal location. Indicates the cytogenetic location of the gene or region on the chromosome, e.g., \code{'19q13.43'}. In the absence of that information, it may be listed as \code{'not on reference assembly'}, \code{'unplaced'}, or \code{'reserved'}.
\item \code{location_sortable}: A sortable version of the \code{location} column, allowing easier sorting by chromosomal location.
\item \code{alias_symbol}: Alternative symbols that have been used to refer to the gene. Aliases may be from literature, other databases, or represent membership of a gene group.
\item \code{alias_name}: Alternative names for the gene. Aliases may be from literature, other databases, or represent membership of a gene group.
\item \code{prev_symbol}: This field displays any symbols that were previously HGNC-approved nomenclature.
\item \code{prev_name}: This field displays any names that were previously HGNC-approved nomenclature.
\item \code{gene_group}: A gene group. Each gene has been assigned to one or more groups, according to either sequence similarity or information from publications, specialist advisors, or other databases.
\item \code{gene_group_id}: Gene group identifier, an integer number. This column contains the gene group identifiers. See \code{gene_group} for the gene group name.
\item \code{date_approved_reserved}: The date the entry was first approved.
\item \code{date_symbol_changed}: The date the gene symbol was last changed.
\item \code{date_name_changed}: The date the gene name was last changed.
\item \code{date_modified}: Date the entry was last modified.
\item \code{entrez_id}: Entrez gene identifier.
\item \code{ensembl_gene_id}: Ensembl gene identifier.
\item \code{vega_id}: VEGA gene identifier.
\item \code{ucsc_id}: UCSC gene identifier.
\item \code{ena}: International Nucleotide Sequence Database Collaboration (GenBank, ENA and DDBJ) accession number(s).
\item \code{refseq_accession}: The Reference Sequence (RefSeq) identifier for that entry, provided by the NCBI.
\item \code{ccds_id}: Consensus CDS identifier.
\item \code{uniprot_ids}: UniProt protein accession.
\item \code{pubmed_id}: Pubmed and Europe Pubmed Central PMIDs.
\item \code{mgd_id}: Mouse genome informatics database identifier.
\item \code{rgd_id}: Rat genome database gene identifier.
\item \code{lsdb}: The name of the Locus Specific Mutation Database and URL for the gene.
\item \code{cosmic}: Symbol used within the Catalogue of somatic mutations in cancer for the gene.
\item \code{omim_id}: Online Mendelian Inheritance in Man (OMIM) identifier.
\item \code{mirbase}: miRBase identifier.
\item \code{homeodb}: Homeobox Database identifier.
\item \code{snornabase}: snoRNABase identifier.
\item \code{bioparadigms_slc}: Symbol used to link to the SLC tables database at bioparadigms.org for the gene.
\item \code{orphanet}: Orphanet identifier.
\item \code{pseudogene_org}: Pseudogene.org identifier.
\item \code{horde_id}: Symbol used within HORDE for the gene.
\item \code{merops}: Identifier used to link to the MEROPS peptidase database.
\item \code{imgt}: Symbol used within international ImMunoGeneTics information system.
\item \code{iuphar}: The objectId used to link to the IUPHAR/BPS Guide to PHARMACOLOGY database.
\item \code{kznf_gene_catalog}: Lawrence Livermore National Laboratory Human KZNF Gene Catalog (LLNL) identifier.
\item \code{mamit_trnadb}: Identifier to link to the Mamit-tRNA database.
\item \code{cd}: Symbol used within the Human Cell Differentiation Molecule database for the gene.
\item \code{lncrnadb}: lncRNA Database identifier.
\item \code{enzyme_id}: ENZYME EC accession number.
\item \code{intermediate_filament_db}: Identifier used to link to the Human Intermediate Filament Database.
\item \code{rna_central_ids}: Identifier in the RNAcentral, The non-coding RNA sequence database.
\item \code{lncipedia}: The LNCipedia identifier to which the gene belongs. This will only appear if the gene is a long non-coding RNA.
\item \code{gtrnadb}: The GtRNAdb identifier to which the gene belongs. This will only appear if the gene is a tRNA.
\item \code{agr}: The Alliance of Genomic Resources HGNC ID for the Human gene page within the resource.
\item \code{mane_select}: MANE Select nucleotide accession with version (i.e., NCBI RefSeq or Ensembl transcript ID and version).
\item \code{gencc}: Gene Curation Coalition (GenCC) Database identifier.
}
}
\description{
\code{\link[=import_hgnc_dataset]{import_hgnc_dataset()}} imports HGNC data into R. Specify a directory \code{path}
in addition if you wish the save the data to disk.
}
\examples{
\dontrun{import_hgnc_dataset()}

}
