% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension-utils.R
\name{generic_implementations}
\alias{generic_implementations}
\title{Retrieve generic function implementations}
\usage{
generic_implementations(generic, remove_default = TRUE)
}
\arguments{
\item{generic}{name of the generic function.}

\item{remove_default}{whether to keep the default generic implementation in the result.}
}
\value{
A vector with class names for which argument '\code{generic}' has an implementation.
}
\description{
Obtains a list of classes for which the supplied generic function has an implementation.
}
\note{
Removes the default generic implementation
}
\examples{
#get a list of classes which have an implementation for graphics::plot
impls = generic_implementations('plot')

}
\seealso{
Other developer functions: 
\code{\link{crossref_description}()},
\code{\link{load_packages}()},
\code{\link{update_settings}()},
\code{\link{valid_pkgname}()}
}
\concept{developer functions}
