% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_data_constructors.R
\name{CAN_data}
\alias{CAN_data}
\title{Creates a \code{CAN_data} object}
\usage{
CAN_data(dat, keep_rownames_as = NULL)
}
\arguments{
\item{dat}{Tibble, set of candidate genes of interest. See Details.}

\item{keep_rownames_as}{Character, the name of the column in which to save the
rownames of the input data-frame. Default value is \code{NULL}, i.e. rownames will
be discarded.}
}
\value{
A \code{CAN_data} object, i.e. a tibble.
}
\description{
Creates a \code{CAN_data} object from a tibble or data-frame of candidate genes.
}
\details{
The input data should have one row per gene, and at least the
following columns:
\itemize{
\item \code{chromosome}: character column, chromosome on which the gene is located.
\item \code{start} and \code{end}: numeric, starting and end position of the gene (in bp).
A column \code{position} will be constructed as the middle value (mean) between
\code{start} and \code{end}.
\item \code{name}: character, the name of the candidate genes to be displayed.
}
}
\examples{
x <- get_example_data()

CAN_data(x[["CAN"]])
}
