% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api.R
\name{hc_scrollbar}
\alias{hc_scrollbar}
\title{Scrollbar options for highcharter objects}
\usage{
hc_scrollbar(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highstock/scrollbar}.}
}
\description{
The scrollbar is a means of panning over the X axis of a stock chart.
Scrollbars can  also be applied to other types of axes.
Another approach to scrollable charts is the chart.scrollablePlotArea option that
is especially suitable for simpler cartesian charts on mobile.
In styled mode, all the presentational options for the
scrollbar are replaced by the classes .highcharts-scrollbar-thumb,
.highcharts-scrollbar-arrow, .highcharts-scrollbar-button,
.highcharts-scrollbar-rifles and .highcharts-scrollbar-track.
}
\examples{

highchart(type = "stock") \%>\%
  hc_add_series(AirPassengers) \%>\%
  hc_rangeSelector(selected = 4) \%>\%
  hc_scrollbar(
    barBackgroundColor = "gray",
    barBorderRadius = 7,
    barBorderWidth = 0,
    buttonBackgroundColor = "gray",
    buttonBorderWidth = 0,
    buttonArrowColor = "yellow",
    buttonBorderRadius = 7,
    rifleColor = "yellow",
    trackBackgroundColor = "white",
    trackBorderWidth = 1,
    trackBorderColor = "silver",
    trackBorderRadius = 7
  )
}
