% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_taxa_parti_pairwise.R
\name{hill_taxa_parti_pairwise}
\alias{hill_taxa_parti_pairwise}
\title{Pairwise comparisons for all sites}
\usage{
hill_taxa_parti_pairwise(
  comm,
  q = 0,
  rel_then_pool = TRUE,
  output = c("data.frame", "matrix"),
  pairs = c("unique", "full"),
  .progress = TRUE,
  show_warning = TRUE,
  ...
)
}
\arguments{
\item{comm}{A data frame of vegetation data. Sites as rows, species as columns.}

\item{q}{Hill number, \code{q} = 0 (default) to get species richness,
\code{q} = 1 to get shannon entropy, \code{q} = 2 will give inverse Simpson.}

\item{rel_then_pool}{default is \code{TRUE.} Abundance of species are first changed to relative abundance within sites,
then pooled into one assemblage. If \code{FALSE}, sites are pooled first, then change abundance of species
to relative abundance.}

\item{output}{output type: data.frame (default) or matrix. If matrix, then this function will return a list of matrices.}

\item{pairs}{full or unique (default). Do you want to compare all possible pairs (i.e. n^2) or just unique pairs (i.e. \code{choose(n, 2))}?}

\item{.progress}{Whether to show progress bar. Default is `TRUE`.}

\item{show_warning}{whether to print warning, default is \code{TRUE}.}

\item{...}{other arguments in \code{hill_taxa_parti()}.}
}
\value{
A data frame with results for all pairwise comparisons.
}
\description{
Calculate pairwise taxonomic gamma, alpha, and beta diversity for communities, as
well as site similarity. It is based on \code{\link{hill_taxa_parti}}.
If comm has >2 sites, this function will give results for all pairwise comparisons.
}
\examples{
\dontrun{
dummy = FD::dummy
hill_taxa_parti_pairwise(comm = dummy$abun, q = 0)
hill_taxa_parti_pairwise(comm = dummy$abun, q = 0, output = 'matrix')
hill_taxa_parti_pairwise(comm = dummy$abun, q = 1)
hill_taxa_parti_pairwise(comm = dummy$abun, q = 0.9999999)
hill_taxa_parti_pairwise(comm = dummy$abun, q = 0.9999999, rel_then_pool = FALSE)
hill_taxa_parti_pairwise(comm = dummy$abun, q = 1, rel_then_pool = FALSE)
hill_taxa_parti_pairwise(comm = dummy$abun, q = 2)
hill_taxa_parti_pairwise(comm = dummy$abun, q = 3)
}
}
\references{
Chao, Anne, Chun-Huo Chiu, and Lou Jost. Unifying Species Diversity, Phylogenetic Diversity, Functional Diversity, and Related Similarity and Differentiation Measures Through Hill Numbers. Annual Review of Ecology, Evolution, and Systematics 45, no. 1 (2014): 297–324. <doi:10.1146/annurev-ecolsys-120213-091540>.

Jost, Lou. Entropy and diversity. Oikos 113, no. 2 (2006): 363-375. <doi:10.1111/j.2006.0030-1299.14714.x>.
}
\seealso{
\code{\link{hill_taxa_parti}}
}
