% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start.R
\name{tmr_start}
\alias{tmr_start}
\title{Start hms Timer}
\usage{
tmr_start(x, ..., title = NULL)
}
\arguments{
\item{x}{A \code{\link[=hms_timer]{hms_timer()}}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{title}{A string of the title.}
}
\value{
A started \code{\link[=hms_timer]{hms_timer()}}.
}
\description{
Starts a \code{\link[=hms_timer]{hms_timer()}} by adding an attribute named
start of the current system time.
}
\details{
If the \code{\link[=hms_timer]{hms_timer()}} is already started, the function
simply issues a warning and returns the original object.
}
\examples{
tmr <- tmr_start(tmr_timer())
print(tmr_elapsed(tmr))
Sys.sleep(0.01)
print(tmr_elapsed(tmr))
}
\seealso{
Other start_stop: 
\code{\link{tmr_elapsed}()},
\code{\link{tmr_is_started}()},
\code{\link{tmr_is_stopped}()},
\code{\link{tmr_print}()},
\code{\link{tmr_reset}()},
\code{\link{tmr_stop}()},
\code{\link{tmr_timer}()}
}
\concept{start_stop}
