% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multvar.R
\name{sim_discr}
\alias{sim_discr}
\title{Simulate co-varying variables with different means by group}
\usage{
sim_discr(.data, n_vars, var, cov, group_means, name = NA, seed = NA)
}
\arguments{
\item{.data}{A dataframe containing a grouping variable column.}

\item{n_vars}{Number of variables to simulate.}

\item{var}{Variance used to construct variance-covariance matrix.}

\item{cov}{Covariance used to construct variance-covariance matrix.}

\item{group_means}{A vector of the same length as the number of grouping variables.}

\item{name}{An optional name to be appended to the column names in the output.}

\item{seed}{An optional seed for random number generation.  If `NA` (default) a random seed will be used.}
}
\value{
a tibble
}
\description{
To-do: make this work with `dplyr::group_by()` instead of `group =`
}
\examples{
library(dplyr)
sim_cat(n_obs = 30, n_groups = 3) \%>\%
group_by(group) \%>\%
sim_discr(n_vars = 5, var = 1, cov = 0.5, group_means = c(-1, 0, 1), name = "descr")
}
\seealso{
\code{\link{sim_cat}}, \code{\link{sim_covar}}

Other multivariate normal functions: 
\code{\link{sim_cat}()},
\code{\link{sim_covar}()}
}
\concept{multivariate normal functions}
