% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_nba_data.R
\name{espn_nba_betting}
\alias{espn_nba_betting}
\title{\strong{Get ESPN NBA's Betting information}}
\usage{
espn_nba_betting(game_id)
}
\arguments{
\item{game_id}{Game ID}
}
\value{
Returns a named list of data frames: pickcenter, againstTheSpread, predictor

\strong{pickcenter}\tabular{ll}{
   col_name \tab types \cr
   details \tab character \cr
   over_under \tab numeric \cr
   spread \tab numeric \cr
   provider_id \tab integer \cr
   provider_name \tab character \cr
   provider_priority \tab integer \cr
   away_team_odds_favorite \tab logical \cr
   away_team_odds_underdog \tab logical \cr
   away_team_odds_money_line \tab integer \cr
   away_team_odds_spread_odds \tab numeric \cr
   away_team_odds_team_id \tab integer \cr
   away_team_odds_win_percentage \tab numeric \cr
   away_team_odds_average_score \tab numeric \cr
   away_team_odds_money_line_odds \tab numeric \cr
   away_team_odds_spread_return \tab numeric \cr
   away_team_odds_spread_record_wins \tab integer \cr
   away_team_odds_spread_record_losses \tab integer \cr
   away_team_odds_spread_record_pushes \tab integer \cr
   away_team_odds_spread_record_summary \tab character \cr
   home_team_odds_favorite \tab logical \cr
   home_team_odds_underdog \tab logical \cr
   home_team_odds_money_line \tab integer \cr
   home_team_odds_spread_odds \tab numeric \cr
   home_team_odds_team_id \tab integer \cr
   home_team_odds_win_percentage \tab numeric \cr
   home_team_odds_average_score \tab numeric \cr
   home_team_odds_money_line_odds \tab numeric \cr
   home_team_odds_spread_return \tab numeric \cr
   home_team_odds_spread_record_wins \tab integer \cr
   home_team_odds_spread_record_losses \tab integer \cr
   home_team_odds_spread_record_pushes \tab integer \cr
   home_team_odds_spread_record_summary \tab character \cr
   game_id \tab integer \cr
}


\strong{againstTheSpread}\tabular{ll}{
   col_name \tab types \cr
   id \tab integer \cr
   uid \tab character \cr
   display_name \tab character \cr
   abbreviation \tab character \cr
   logo \tab character \cr
   logos \tab list \cr
   records \tab list \cr
   game_id \tab integer \cr
   team_id \tab integer \cr
}


\strong{predictor}\tabular{ll}{
   col_name \tab types \cr
   game_id \tab integer \cr
   home_team_id \tab integer \cr
   away_team_id \tab integer \cr
   away_team_game_projection \tab numeric \cr
   away_team_chance_loss \tab numeric \cr
}
}
\description{
\strong{Get ESPN NBA's Betting information}
}
\examples{
\donttest{
  try(espn_nba_betting(game_id = 401283399))
}
}
\seealso{
Other ESPN NBA Functions: 
\code{\link{espn_nba_game_all}()},
\code{\link{espn_nba_game_rosters}()},
\code{\link{espn_nba_pbp}()},
\code{\link{espn_nba_player_box}()},
\code{\link{espn_nba_player_stats}()},
\code{\link{espn_nba_scoreboard}()},
\code{\link{espn_nba_standings}()},
\code{\link{espn_nba_team_box}()},
\code{\link{espn_nba_team_stats}()},
\code{\link{espn_nba_teams}()},
\code{\link{espn_nba_wp}()}
}
\concept{ESPN NBA Functions}
\keyword{Betting}
\keyword{NBA}
