% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_hustle.R
\name{nba_leaguehustlestatsplayer}
\alias{nba_leaguehustlestatsplayer}
\title{\strong{Get NBA Stats API League Hustle Stats Player}}
\usage{
nba_leaguehustlestatsplayer(
  college = "",
  conference = "",
  country = "",
  date_from = "",
  date_to = "",
  division = "",
  draft_pick = "",
  draft_year = "",
  height = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  per_mode = "Totals",
  player_experience = "",
  player_position = "",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  weight = "",
  ...
)
}
\arguments{
\item{college}{college}

\item{conference}{conference}

\item{country}{country}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{draft_pick}{draft_pick}

\item{draft_year}{draft_year}

\item{height}{height}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{per_mode}{per_mode}

\item{player_experience}{player_experience}

\item{player_position}{player_position}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{weight}{weight}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: HustleStatsPlayer

\strong{HustleStatsPlayer}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   AGE \tab character \cr
   G \tab character \cr
   MIN \tab character \cr
   CONTESTED_SHOTS \tab character \cr
   CONTESTED_SHOTS_2PT \tab character \cr
   CONTESTED_SHOTS_3PT \tab character \cr
   DEFLECTIONS \tab character \cr
   CHARGES_DRAWN \tab character \cr
   SCREEN_ASSISTS \tab character \cr
   SCREEN_AST_PTS \tab character \cr
   OFF_LOOSE_BALLS_RECOVERED \tab character \cr
   DEF_LOOSE_BALLS_RECOVERED \tab character \cr
   LOOSE_BALLS_RECOVERED \tab character \cr
   PCT_LOOSE_BALLS_RECOVERED_OFF \tab character \cr
   PCT_LOOSE_BALLS_RECOVERED_DEF \tab character \cr
   OFF_BOXOUTS \tab character \cr
   DEF_BOXOUTS \tab character \cr
   BOX_OUT_PLAYER_TEAM_REBS \tab character \cr
   BOX_OUT_PLAYER_REBS \tab character \cr
   BOX_OUTS \tab character \cr
   PCT_BOX_OUTS_OFF \tab character \cr
   PCT_BOX_OUTS_DEF \tab character \cr
   PCT_BOX_OUTS_TEAM_REB \tab character \cr
   PCT_BOX_OUTS_REB \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Hustle Stats Player}

\strong{Get NBA Stats API League Hustle Stats Player}
}
\details{
\href{https://www.nba.com/stats/players/hustle}{Player Hustle Stats}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguehustlestatsplayer(league_id = '00')
 nba_leaguehustlestatsplayer(league_id = '00', team_id = '1610612761')

}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Hustle Functions: 
\code{\link{nba_hustlestatsboxscore}()},
\code{\link{nba_leaguehustlestatsplayerleaders}()},
\code{\link{nba_leaguehustlestatsteamleaders}()},
\code{\link{nba_leaguehustlestatsteam}()}
}
\author{
Saiem Gilani
}
\concept{NBA Hustle Functions}
