% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_lineups.R
\name{nba_leaguelineupviz}
\alias{nba_leaguelineupviz}
\title{\strong{Get NBA Stats API League Lineup Visual Data}}
\usage{
nba_leaguelineupviz(
  conference = "",
  date_from = "",
  date_to = "",
  division = "",
  game_segment = "",
  group_quantity = 5,
  last_n_games = 0,
  league_id = "00",
  location = "",
  measure_type = "Base",
  minutes_min = 10,
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  plus_minus = "N",
  rank = "N",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{conference}{conference}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{game_segment}{game_segment}

\item{group_quantity}{group_quantity}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{measure_type}{measure_type}

\item{minutes_min}{minutes_min}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueLineupViz

\strong{LeagueLineupViz}\tabular{ll}{
   col_name \tab types \cr
   GROUP_ID \tab character \cr
   GROUP_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   MIN \tab character \cr
   OFF_RATING \tab character \cr
   DEF_RATING \tab character \cr
   NET_RATING \tab character \cr
   PACE \tab character \cr
   TS_PCT \tab character \cr
   FTA_RATE \tab character \cr
   TM_AST_PCT \tab character \cr
   PCT_FGA_2PT \tab character \cr
   PCT_FGA_3PT \tab character \cr
   PCT_PTS_2PT_MR \tab character \cr
   PCT_PTS_FB \tab character \cr
   PCT_PTS_FT \tab character \cr
   PCT_PTS_PAINT \tab character \cr
   PCT_AST_FGM \tab character \cr
   PCT_UAST_FGM \tab character \cr
   OPP_FG3_PCT \tab character \cr
   OPP_EFG_PCT \tab character \cr
   OPP_FTA_RATE \tab character \cr
   OPP_TOV_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Lineup Visual Data}

\strong{Get NBA Stats API League Lineup Visual Data}
}
\details{
\href{https://www.nba.com/stats/lineups/traditional}{Lineups Dashboard}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguelineupviz(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguegamelog}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_leaguestandings}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()},
\code{\link{nba_shotchartleaguewide}()}

Other NBA Lineup Functions: 
\code{\link{nba_gamerotation}()},
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_shotchartlineupdetail}()},
\code{\link{nba_teamdashlineups}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
\concept{NBA Lineup Functions}
