% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_shotchart.R
\name{nba_shotchartlineupdetail}
\alias{nba_shotchartlineupdetail}
\title{\strong{Get NBA Stats API Shot Chart for Lineups}}
\usage{
nba_shotchartlineupdetail(
  ahead_behind = "",
  cfid = "",
  cfparams = "",
  clutch_time = "",
  conference = "",
  context_filter = "",
  context_measure = "FGA",
  date_from = "",
  date_to = "",
  division = "",
  end_period = "10",
  end_range = "28800",
  group_id = "-202689-203493-203501-1626174-1627827-",
  game_event_id = "",
  game_id = "",
  game_segment = "",
  group_mode = "",
  group_quantity = "5",
  last_n_games = "0",
  league_id = "00",
  location = "",
  month = "0",
  on_off = "",
  opp_player_id = "",
  opponent_team_id = "0",
  outcome = "",
  po_round = "0",
  period = "0",
  player_id = "0",
  player_id1 = "",
  player_id2 = "",
  player_id3 = "",
  player_id4 = "",
  player_id5 = "",
  player_position = "",
  point_diff = "",
  position = "",
  range_type = "0",
  rookie_year = "",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  start_period = "1",
  start_range = "0",
  starter_bench = "",
  team_id = "1610612742",
  vs_conference = "",
  vs_division = "",
  vs_player_id1 = "",
  vs_player_id2 = "",
  vs_player_id3 = "",
  vs_player_id4 = "",
  vs_player_id5 = "",
  vs_team_id = "",
  ...
)
}
\arguments{
\item{ahead_behind}{ahead_behind}

\item{cfid}{cfid}

\item{cfparams}{cfparams}

\item{clutch_time}{clutch_time}

\item{conference}{conference}

\item{context_filter}{context_filter}

\item{context_measure}{context_measure}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{end_period}{end_period}

\item{end_range}{end_range}

\item{group_id}{group_id}

\item{game_event_id}{game_event_id}

\item{game_id}{game_id}

\item{game_segment}{game_segment}

\item{group_mode}{group_mode}

\item{group_quantity}{group_quantity}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{on_off}{on_off}

\item{opp_player_id}{opp_player_id}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{period}{period}

\item{player_id}{player_id}

\item{player_id1}{player_id1}

\item{player_id2}{player_id2}

\item{player_id3}{player_id3}

\item{player_id4}{player_id4}

\item{player_id5}{player_id5}

\item{player_position}{player_position}

\item{point_diff}{point_diff}

\item{position}{position}

\item{range_type}{range_type}

\item{rookie_year}{rookie_year}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{start_period}{start_period}

\item{start_range}{start_range}

\item{starter_bench}{starter_bench}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{vs_player_id1}{vs_player_id1}

\item{vs_player_id2}{vs_player_id2}

\item{vs_player_id3}{vs_player_id3}

\item{vs_player_id4}{vs_player_id4}

\item{vs_player_id5}{vs_player_id5}

\item{vs_team_id}{vs_team_id}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: ShotChartLineupDetail, ShotChartLineupLeagueAverage

\strong{ShotChartLineupDetail}\tabular{ll}{
   col_name \tab types \cr
   GRID_TYPE \tab character \cr
   GAME_ID \tab character \cr
   GAME_EVENT_ID \tab character \cr
   GROUP_ID \tab character \cr
   GROUP_NAME \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   PERIOD \tab character \cr
   MINUTES_REMAINING \tab character \cr
   SECONDS_REMAINING \tab character \cr
   EVENT_TYPE \tab character \cr
   ACTION_TYPE \tab character \cr
   SHOT_TYPE \tab character \cr
   SHOT_ZONE_BASIC \tab character \cr
   SHOT_ZONE_AREA \tab character \cr
   SHOT_ZONE_RANGE \tab character \cr
   SHOT_DISTANCE \tab character \cr
   LOC_X \tab character \cr
   LOC_Y \tab character \cr
   SHOT_ATTEMPTED_FLAG \tab character \cr
   SHOT_MADE_FLAG \tab character \cr
   GAME_DATE \tab character \cr
   HTM \tab character \cr
   VTM \tab character \cr
}


\strong{ShotChartLineupLeagueAverage}\tabular{ll}{
   col_name \tab types \cr
   GRID_TYPE \tab character \cr
   SHOT_ZONE_BASIC \tab character \cr
   SHOT_ZONE_AREA \tab character \cr
   SHOT_ZONE_RANGE \tab character \cr
   FGA \tab character \cr
   FGM \tab character \cr
   FG_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Shot Chart for Lineups}

\strong{Get NBA Stats API Shot Chart for Lineups}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_shotchartlineupdetail(group_id = '-202689-203493-203501-1626174-1627827-',
                           group_id2 = '-202689-203493-203501-1626174-1627827-',
                           season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Shooting Functions: 
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_shotchartdetail}()},
\code{\link{nba_shotchartleaguewide}()},
\code{\link{nba_teamdashboardbyshootingsplits}()}

Other NBA Lineup Functions: 
\code{\link{nba_gamerotation}()},
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_teamdashlineups}()}
}
\author{
Saiem Gilani
}
\concept{NBA Lineup Functions}
\concept{NBA Shooting Functions}
