% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hopkins.R
\name{hopkins.pval}
\alias{hopkins.pval}
\title{Calculate the p-value for Hopkins statistic}
\usage{
hopkins.pval(x, n)
}
\arguments{
\item{x}{Observed value of Hopkins statistic}

\item{n}{Number of events/points sampled.}
}
\value{
A p-value between 0 and 1.
}
\description{
Calculate the p-value for Hopkins statistic
}
\details{
Under null hypothesis of spatial randomness, Hopkins statistic has a
Beta(m,m) distribution, where 'm' is the number of events/points sampled.
This function calculates the p-value for the statistic.
}
\examples{
hopkins.pval(0.21, 10) # .00466205
}
\references{
Michael T. Gastner (2005).
Spatial distributions: Density-equalizing map projections, facility location, and two-dimensional networks.
Ph.D. dissertation, Univ. Michigan (Ann Arbor, 2005).
http://hdl.handle.net/2027.42/125368
}
\author{
Kevin Wright
}
