% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-descriptor.file.r
\name{descriptor.file}
\alias{descriptor.file}
\alias{descriptor.file,mmatrix-method}
\alias{descriptor.file,mvector-method}
\alias{descriptor.file,marray-method}
\title{Descriptor file}
\usage{
descriptor.file(object)

\S4method{descriptor.file}{mmatrix}(object)

\S4method{descriptor.file}{mvector}(object)

\S4method{descriptor.file}{marray}(object)
}
\arguments{
\item{object}{a memory mapped object}
}
\value{
None.
}
\description{
Descriptor file
}
\details{
Creates a descriptor file, similar to the descriptor files of the package 'bigmemomry'.
This descriptor allows to map the object with the package bigmemory, or the \link{read.descriptor} function
in this package. Its name is obtained by appending ".desc' to the name of the file mapped by 'object'.

A method is available for marrays as well, but the resulting descriptor can't be read by
'bigmemory' as this package doesn't handle arrays. The function 'read.descriptor' in houba can read it.
}
\examples{
A <- mmatrix("short", 10, 20)
A[] <- sample.int(200)

# create descriptor file 
dsc <- descriptor.file(A)

# linking file to other object
B <- read.descriptor(dsc, readonly = FALSE)
all(as.matrix(A) == as.matrix(B)) # TRUE

B[1:10] <- 0
all(A[1:10] == 0) # TRUE

}
\seealso{
\code{read.descriptor}
}
