% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.indexvolatility}
\alias{plot.indexvolatility}
\title{Plot method for `indexvolatility` object}
\usage{
\method{plot}{indexvolatility}(x, ...)
}
\arguments{
\item{x}{Object to plot of class `indexvolatility``}

\item{...}{Additional Arguments}
}
\value{
`plotvolatility` object inheriting from a ggplot object
}
\description{
Specific plotting method for indexvolatility objects
}
\examples{

 # Load Data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Calculate Volatility
 index_vol <- calcVolatility(index = rt_index,
                             window = 3)

 # Make Plot
 plot(index_vol)

}
