% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data_inputs.R
\name{format_design}
\alias{format_design}
\title{Format design}
\usage{
format_design(
  design,
  scale_design = TRUE,
  nS_expect = NULL,
  nT_expect = NULL,
  nD_expect = NULL,
  per_location_design = NULL
)
}
\arguments{
\item{design}{The \code{design} argument input. Will be formatted to a
\code{nS}-length list.}

\item{scale_design}{Scale the design matrix by dividing each column by its
maximum and then subtracting the mean? Default: \code{TRUE}. If
\code{FALSE}, the design matrix is centered but not scaled.}

\item{nS_expect}{The expected number of sessions, if known.}

\item{nT_expect}{The expected number of timepoints, if known. For
multi-session data this is a session-length vector.}

\item{nD_expect}{The expected number of designs, if known. For per-location
modeling this is equal to \code{nVd0}, the initial number of data locations.
For multi-session data this is a session-length vector.}

\item{per_location_design}{\code{FALSE} if per-location modeling is not
being performed (i.e. for multiGLM); \code{TRUE} if it is; or, \code{NULL}
to infer based on the dimensions of \code{design} (\code{TRUE} if the
design has three dimensions.)}
}
\value{
\code{design}
}
\description{
Format design for \code{BayesGLM}, \code{fit_bayesglm},
\code{multiGLM}, and \code{multiGLM_fun}.
}
\keyword{internal}
