% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiGLM.R
\name{multiGLM}
\alias{multiGLM}
\title{multiGLM for CIFTI}
\usage{
multiGLM(
  BOLD,
  design,
  brainstructures = c("left", "right"),
  TR = NULL,
  resamp_res = 10000,
  hpf = NULL,
  nuisance = NULL,
  design_canonical = NULL,
  verbose = 1,
  meanTol = 1e-06,
  varTol = 1e-06
)
}
\arguments{
\item{BOLD}{fMRI timeseries data in CIFTI format ("*.dtseries.nii").
For single-session analysis this can be a file path to a CIFTI file or a
\code{"xifti"} object from the \code{ciftiTools} package. For multi-session
analysis this can be a vector of file paths or a list of \code{"xifti"}
objects.

If \code{BOLD} is a \code{"xifti"} object(s), the surfaces, if any, will be
used for the spatial model. However, if \code{surfL} and \code{surfR} are
provided, they will override any surfaces in \code{BOLD}.}

\item{design}{A 3D numeric array that is locations by fields by designs.}

\item{brainstructures}{Character vector indicating which brain structure(s)
of \code{BOLD} to analyze: \code{"left"} cortex; \code{"right"} cortex;
and/or \code{"subcortical"} structures. Or \code{"all"} to model all three.
Default: \code{c("left","right")} (cortex only).}

\item{TR}{Temporal resolution of the data, in seconds.}

\item{resamp_res}{For cortex spatial model. The number of vertices to which
each cortical surface should be resampled, or \code{NULL} to not resample.

For computational feasibility, a value of \code{10000} (default) or lower is
recommended for Bayesian spatial modeling. If \code{Bayes=FALSE},
\code{resamp_res} can be set to \code{NULL} for full-resolution classical
modeling.}

\item{hpf}{Add DCT bases to \code{nuisance} to apply a temporal high-pass
filter to the data, for detrending? \code{hpf} is the filter frequency.
Use \code{NULL} to skip detrending. Detrending is strongly recommended for
fMRI data, to help reduce the autocorrelation in the residuals, so
\code{NULL} will induce a warning. Use \code{"already"} to disable the
warning while skipping highpass filtering.

Using at least two DCT bases is as sufficient for detrending as using linear
and quadratic drift terms in the nuisance matrix. So if DCT detrending is
being used here, there is no need to add linear and quadratic drift terms to
\code{nuisance}.}

\item{nuisance}{(Optional) A \eqn{T \times N_{nuis}} matrix of nuisance signals,
where \eqn{T} is the number of timepoints and \eqn{N} is the number of
nuisance signals, or a list of these for multi-session analysis. Nuisance
signals are regressed from the fMRI data and design matrix prior to GLM
computation. Nuisance signals can include motion regressors, HRF derivatives
not being modeled as tasks, and other sources of noise.

Detrending/high-pass filtering is accomplished by adding DCT bases to the
nuisance matrix; see the parameters \code{hpf} and \code{DCT}.

Do not add spike regressors for scrubbing to the \code{nuisance} matrix.
Rather, provide these in \code{scrub} so that their corresponding timepoints
are also removed from the BOLD data after nuisance regression.}

\item{design_canonical}{TO DO}

\item{verbose}{\code{1} (default) to print occasional updates during model
computation; \code{2} for occasional updates as well as running INLA in
verbose mode (if \code{Bayes}), or \code{0} for no printed updates.}

\item{meanTol, varTol}{Tolerance for mean and variance of each data location.
Locations which do not meet these thresholds are masked out of the analysis.
Default: \code{1e-6} for both.}
}
\value{
An object of class \code{"mGLM"}: a list with elements
\describe{
\item{brainstructures}{\code{data.frame} summarizing the spatial features of each brain structure modeled.}
\item{fields}{\code{data.frame} with the \code{name}, related \code{task}, and \code{HRF_order} of each field.}
}
}
\description{
Performs classical Bayesian GLM for task fMRI activation with CIFTI-format
data, evaluating multiple design matrices. Includes the pre-processing
steps of nuisance regression. Supports single-session analysis only.
}
\section{Connectome Workbench Requirement}{


This function uses a system wrapper for the 'wb_command' executable. The
user must first download and install the Connectome Workbench, available
from https://www.humanconnectome.org/software/get-connectome-workbench .
}

