% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivregimes_2.R
\name{ivregimes}
\alias{ivregimes}
\title{Estimation of regime models with endogenous variables}
\usage{
ivregimes(formula, data, rgv = NULL, vc = c("homoskedastic", "robust", "OGMM"))
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x_f | x_v | h_f | h_v} where \code{y} is the dependent variable, \code{x_f} are the regressors that do not vary by regimes,  \code{x_v} are the regressors that vary by regimes, \code{h_f} are the fixed instruments and \code{h_v} are the instruments that vary by regimes.}

\item{data}{the data of class \code{data.frame}.}

\item{rgv}{an object of class \code{formula} to identify the regime variables}

\item{vc}{one of \code{c("homoskedastic", "robust", "OGMM")}. If \code{"OGMM"} an optimal weighted GMM is used to estimate the VC matrix.}
}
\value{
An object of class \code{ivregimes}. A \code{list} of five elements. The first element of the list contains the estimation results. The other elements are needed for printing the results.
}
\description{
The function \code{ivregimes} deals with
the estimation of regime models.
Most of the times the variable identifying the regimes
reveals some spatial aspects of the data (e.g., administrative boundaries).
The model includes exogenous as well as endogenous
variables among the regressors.
}
\details{
The basic (non spatial) model with endogenous variables
can be written in a general way as:
 \deqn{
y
=
\begin{bmatrix}
X_1& 0 \\
0 & X_2 \\
\end{bmatrix}
\begin{bmatrix}
\beta_1 \\
\beta_2 \\
\end{bmatrix}
+ X\beta +
\begin{bmatrix}
Y_1& 0 \\
0 & Y_2 \\
\end{bmatrix}
\begin{bmatrix}
\pi_1 \\
\pi_2 \\
\end{bmatrix}
+ Y\pi +
 \varepsilon
}
where  \eqn{y = [y_1^\prime,y_2^\prime]^\prime},
and the \eqn{n_1 \times 1} vector \eqn{y_1} contains the observations
on the dependent variable for the first regime,
and the \eqn{n_2 \times 1} vector \eqn{y_2} (with \eqn{n_1 + n_2 = n})
contains the observations on the dependent variable for the second regime.
The \eqn{n_1 \times k} matrix \eqn{X_1} and the \eqn{n_2 \times k}
matrix \eqn{X_2} are blocks of a block diagonal matrix,
the vectors of parameters  \eqn{\beta_1} and \eqn{\beta_2} have
dimension \eqn{k_1 \times 1} and \eqn{k_2 \times 1}, respectively,
\eqn{X} is the \eqn{n \times p} matrix of regressors that do not vary by regime,
\eqn{\beta}  is a \eqn{p\times 1} vector of parameters.
The three matrices \eqn{Y_1} (\eqn{n_1 \times q}),
\eqn{Y_2} (\eqn{n_2 \times q}) and \eqn{Y} (\eqn{n \times r})
with corresponding vectors of parameters \eqn{\pi_1}, \eqn{\pi_2} and \eqn{\pi},
contain the endogenous variables.
Finally, \eqn{\varepsilon = [\varepsilon_1^\prime,\varepsilon_2^\prime]^\prime}
is the \eqn{n\times 1} vector of innovations.
The model is estimated by two stage least square.
In particular:
\itemize{
\item If \code{vc = "homoskedastic"},
the variance-covariance matrix is estimated by \eqn{\sigma^2(\hat Z^\prime \hat Z)^{-1}},
where \eqn{\hat Z= PZ},  \eqn{P= H(H^\prime H)^{-1}H^\prime}, \eqn{H} is the matrix of instruments,
and \eqn{Z} is the matrix of all exogenous and endogenous variables in the model.

\item If \code{vc = "robust"}, the variance-covariance matrix is estimated by
\eqn{(\hat Z^\prime \hat Z)^{-1}(\hat Z^\prime \hat\Sigma \hat Z) (\hat Z^\prime \hat Z)^{-1}},
where \eqn{\hat\Sigma} is a diagonal matrix with diagonal elements \eqn{\hat\sigma_i},
for \eqn{i=1,...,n}.
\item Finally, if \code{vc = "OGMM"}, the model is estimated in two steps.
In the first step, the model is estimated by 2SLS yielding
the residuals \eqn{\hat \varepsilon}.
With the residuals, the diagonal matrix \eqn{\hat \Sigma} is estimated and is
used to construct the matrix \eqn{\hat S = H^\prime \hat \Sigma H}.
Then \eqn{\eta_{OWGMM}=(Z^\prime H\hat S^{-1}H^\prime Z)^{-1}Z^\prime H\hat S^{-1}H^\prime y}, where \eqn{\eta_{OWGMM}}
is the vector of all the parameters in the model,
The variance-covariance matrix is: \eqn{n(Z^\prime H\hat S^{-1}H^\prime Z)^{-1}}.}
}
\examples{
data("natreg")
form   <- HR90  ~ 0 | MA90 + PS90 + RD90 + UE90 | 0 | MA90 + PS90 + RD90 + FH90 + FP89 + GI89
split  <- ~ REGIONS
mod <- ivregimes(formula = form, data = natreg, rgv = split, vc = "robust")
summary(mod)
mod1 <- ivregimes(formula = form, data = natreg, rgv = split, vc = "OGMM")
summary(mod1)
form1   <- HR90  ~ MA90 + PS90 |  RD90 + UE90 -1 | MA90 + PS90 | RD90 + FH90 + FP89 + GI89 -1
mod2 <- ivregimes(formula = form1, data = natreg, rgv = split, vc = "homoskedastic")
summary(mod2)

}
\author{
Gianfranco Piras and Mauricio Sarrias
}
