% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsrecombi.R
\name{hsrecombi}
\alias{hsrecombi}
\title{Estimation of recombination rate and maternal LD}
\usage{
hsrecombi(hap, genotype.chr, exclude = NULL, only.adj = FALSE, prec = 1e-06)
}
\arguments{
\item{hap}{list (LEN 2) of lists
\describe{
  \item{famID}{list (LEN number of sires) of vectors (LEN n.progeny) of
   progeny indices relating to lines in genotype matrix}
  \item{sireHap}{list (LEN number of sires) of matrices (DIM 2 x p)
   of sire haplotypes (0, 1) on investigated chromosome}
}}

\item{genotype.chr}{matrix (DIM n x p) of all progeny genotypes (0, 1, 2) on
a chromosome with p SNPs; 9 indicates missing genotype}

\item{exclude}{vector (LEN < p) of SNP IDs (for filtering column names of
\code{genotype.chr)} to be excluded from analysis (default NULL)}

\item{only.adj}{logical; if \code{TRUE}, recombination rate is calculated
only between neighbouring markers}

\item{prec}{scalar; precision of estimation}
}
\value{
list (LEN p - 1) of data.frames; for each SNP, parameters are
  estimated with all following SNPs; two solutions (prefix sln1 and sln2) are
  obtained for two runs of the EM algorithm
\describe{
  \item{\code{SNP1}}{ID of 1. SNP}
  \item{\code{SNP2}}{ID of 2. SNP}
  \item{\code{D}}{maternal LD}
  \item{\code{fAA}}{frequency of maternal haplotype 1-1}
  \item{\code{fAB}}{frequency of maternal haplotype 1-0}
  \item{\code{fBA}}{frequency of maternal haplotype 0-1}
  \item{\code{fBB}}{frequency of maternal haplotype 0-0}
  \item{\code{p1}}{Maternal allele frequency (allele 1) at \code{SNP1}}
  \item{\code{p2}}{Maternal allele frequency (allele 1) at \code{SNP2}}
  \item{\code{nfam1}}{size of genomic family 1}
  \item{\code{nfam2}}{size of genomic family 2}
  \item{\code{error}}{0 if computations were without error; 1 if EM algorithm
    did not converge}
  \item{\code{iteration}}{number of EM iterations}
  \item{\code{theta}}{paternal recombination rate}
  \item{\code{r2}}{\eqn{r^2} of maternal LD}
  \item{\code{logL}}{value of log likelihood function}
  \item{\code{unimodal}}{1 if likelihood is unimodal; 0 if likelihood is
    bimodal}
  \item{\code{critical}}{0 if parameter estimates are unique; 1 if parameter
    estimates at both solutions are valid, then decision process follows in
    post-processing function "editraw"}
}
  Afterwards, solutions are compared and processed with function
  \code{editraw}, yielding the final estimates for each valid pair of SNPs.
}
\description{
Wrapper function for estimating recombination rate and maternal
  linkage disequilibrium between intra-chromosomal SNP pairs by calling EM
  algorithm
}
\details{
Paternal recombination rate and maternal linkage disequilibrium (LD)
  are estimated for pairs of biallelic markers (such as single nucleotide
  polymorphisms; SNPs) from progeny genotypes and sire haplotypes. At least
  one sire has to be double heterozygous at the investigated pairs of SNPs.
  All progeny are merged in two genomic families: (1) coupling phase family
  if sires are double heterozygous 0-0/1-1 and (2) repulsion phase family if
  sires are double heterozygous 0-1/1-0.
  So far it is recommended processing the chromosomes separately.
  If maternal half-sib families are used, the roles of sire/dam are swapped.
  Multiple families can be considered.
}
\examples{
  ### test data
  data(targetregion)
  ### make list for paternal half-sib families
  hap <- makehaplist(daughterSire, hapSire)
  ### parameter estimates on a chromosome
  res <- hsrecombi(hap, genotype.chr)
  ### post-processing to achieve final and valid set of estimates
  final <- editraw(res, map.chr)
}
\references{
Hampel, A., Teuscher, F., Gomez-Raya, L., Doschoris, M. & Wittenburg, D.
   (2018) Estimation of recombination rate and maternal linkage
   disequilibrium in half-sibs. Frontiers in Genetics 9:186.
   \doi{10.3389/fgene.2018.00186}

  Gomez-Raya, L. (2012) Maximum likelihood estimation of linkage
   disequilibrium in half-sib families. Genetics 191:195-213.
}
