% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydroDCindex.R
\name{hydroDC_Index}
\alias{hydroDC_Index}
\title{Duration Curve Hydrological Model Indexes}
\usage{
hydroDC_Index(Q_obs, Q_sim, c_opt)
}
\arguments{
\item{Q_obs}{Column with daily observed flows}

\item{Q_sim}{Column with daily simulated flows}

\item{c_opt}{Results, default 1 for indexes, 2 for duration curve values, 3 for DC plot and 4 for scatter plot}
}
\value{
BiasFMS: Diagnosis of vertical redistribution in the midsection of the duration curve.

BiasFHV: Bias in peak flows.

BiasFLV: Bias at low flows.

BiasFMM_log: Log_Mean Flow Bias.

BiasFMM: Mean Flow Bias.

Pexc: Exceedance probability computed with Weibull formula.

Amount_Obs: Observations in ascending order.

Amount_Sim: Simulations in ascending order.

r_pearson: Imported method from stats package, results in the Pearson product-moment correlation coefficient, -1 <= r_pearson <= 1

MAE: Imported method from ie2misc package, results in the Mean Absolute Error.

rsq: Results in the Coefficient of Determination, estimated as the squared of correlation, 0 <= R2 <= 1

NSE: Imported method from ie2misc package, results in the Nash-Sutcliffe Efficiency, -Inf <= NSE <= 1

KGE: Results in the Kling-Gupta Efficiency, 0 <= KGE <= 1
}
\description{
Duration Curve Hydrological Model Indexes
}
\details{
{
If \code{c_opt=1}, it computes the numerical values of: \cr
'BiasFMS','BiasFHV','BiasFLV','BiasFMM_log','BiasFMM'
If \code{c_opt=2}, it computes the duration curve values: \cr
'Pexc','Amount_Obs','Amount_Sim'
If \code{c_opt=3}, it plots the duration curves.
If \code{c_opt=4}, it plots scattered values and computes the numerical values of: \cr
'r_pearson','MAE','rsq','NSE','KGE'
}
}
\examples{

  Obs <- hydroDCindex::Q_obs
  Sim <- hydroDCindex::Q_sim
  # option 1 for indexes
  hydroDCindex::hydroDC_Index(Obs, Sim, 1)
  # option 2 for duration curve values
  hydroDCindex::hydroDC_Index(Obs, Sim, 2)
  # option 3 for duration curve plot
  hydroDCindex::hydroDC_Index(Obs, Sim, 3)
  # option 4 for scatter plot with goodness of fit tests
  hydroDCindex::hydroDC_Index(Obs, Sim, 4)


}
