\name{plot_pof}

\alias{plot_pof}

\title{
Plotting Pareto-optimal Fronts and Best Compromise Solutions
}

\description{
The function \code{plot_pof} generates plots of the Pareto-optimal front (POF) 
and the best compromise solution (BCS) in multi-objective optimization for 
hydrological models. It visualizes trade-offs between different objectives and 
helps identify the most balanced solution, assisting in model calibration and 
evaluation processes. \cr

\bold{(*)}: When \code{do.png == TRUE}, graphics are written to disk. \cr
}

\usage{
plot_pof(Results,
         pof = NULL,
         bcs = NULL,
         analysis.period = NULL,
         dimensions = NULL,
         maxmin = NULL,
         obj.thr = NULL,
         obj.names = NULL,
         main = "study case #1",
         drty.out = "MOPSO.out", 
         pch.pof = 21,
         pch.bcs = 21,
         col.pof = "#f21b1b",
         col.bcs = "#004fcf",
         legend.pof = c("Pareto-optimal front solutions", "Best compromise solution"),
         cex.pt = 1.25,
         cex.main = 1,
         cex.lab = 1,
         cex.axis = 1,
         do.png = FALSE)
}
            
\arguments{
  \item{Results}{(\code{list}) \cr
    Object containing preprocessed hydrological results.
  }
  \item{pof}{(\code{matrix} or \code{NULL}) \cr
    Dataset representing the filled Pareto-optimal front (POF) solutions.
  }
  \item{bcs}{(\code{matrix} or \code{NULL}) \cr
    Parameters or results corresponding to the best compromise solution (BCS).
  }
  \item{analysis.period}{(\code{character} or \code{NULL}) \cr
    Time period for analysis (e.g., "calibration" or "verification").
  }
  \item{dimensions}{(\code{numeric} or \code{NULL}) \cr
    Dimensions of the modeled problem, typically indicating the number of 
    objectives and variables.
  }
  \item{maxmin}{(\code{character} or \code{NULL}) \cr
    Indicator of whether objectives are to be maximized ("max") or minimized 
    ("min").
  }
  \item{obj.thr}{(\code{numeric} or \code{NULL}) \cr
    Objective thresholds.
  }
  \item{obj.names}{(\code{character} or \code{NULL}) \cr
    Names of the objectives used in the plot.
  }
  \item{main}{(\code{character}) \cr
    Main title for the plot.
  }
  \item{drty.out}{(\code{character}) \cr
    Output directory where plots will be saved if specified to save as PNG files.
  }
  \item{pch.pof}{(\code{integer}) \cr
    Symbol type for points in the plot representing the Pareto-optimal front 
    solutions.
  }
  \item{pch.bcs}{(\code{integer}) \cr
    Symbol type for points in the plot representing the best compromise 
    solution (BCS).
  }
  \item{col.pof}{(\code{character}) \cr
    Color used for the points representing the Pareto-optimal front solutions 
    in the plots.
  }
  \item{col.bcs}{(\code{character}) \cr
    Color used for the points representing the best compromise solution in the 
    plots.
  }
  \item{legend.pof}{(\code{character}) \cr
    Legend text for the Pareto-optimal front and best compromise solution.
  }
  \item{cex.pt}{(\code{numeric}) \cr
    Size of points in the plots.
  }
  \item{cex.main}{(\code{numeric}) \cr
    Size of the main title text in the plot.
  }
  \item{cex.lab}{(\code{numeric}) \cr
    Size of the axis label text in the plots.
  }
  \item{cex.axis}{(\code{numeric}) \cr
    Size of the axis values text in the plots.
  }
  \item{do.png}{(\code{logical}) \cr
    Boolean value indicating whether the plots should be saved as PNG files.
  }
}

\value{
No return value; generates plots as a side effect.
}

\author{
Rodrigo Marinao Rivas \email{ra.marinao.rivas@gmail.com}, 
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}

\seealso{
\code{\link{plot_out}}, \code{\link{plot_param}}
}

\keyword{multi-objective optimisation}
\keyword{hydrological model}
\keyword{Pareto front}
