% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{get.AIC}
\alias{get.AIC}
\title{Get AIC}
\usage{
get.AIC(model)
}
\arguments{
\item{model}{fitted \code{hydroState} model object.}
}
\value{
AIC value of a single model or a list variable of AIC values for al models
}
\description{
\code{get.AIC} retrieves Akaike information criteria from a fitted hydroState model object or all models.
}
\details{
\code{get.AIC}

The AIC is the negative log-likelihood of the model plus a penalty for model parameters. This function can be performed on a single model or a selection of models to find the lowest AIC of the set.
}
\examples{
# Load fitted model
data(model.annual.fitted.221201)

## AIC of a single model
get.AIC(model.annual.fitted.221201)

## Lowest AIC of a model set
get.AIC(all.models.annual.fitted.407211)

}
\keyword{AIC}
