% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qmm_to_Dm.R
\name{Qmm_to_Dm}
\alias{Qmm_to_Dm}
\title{River discharge [m3/s] to  volume [hm3]}
\usage{
Qmm_to_Dm(df)
}
\arguments{
\item{df}{data frame with class Date in the first column. By default the function converts the second column only. If you have daily or hourly data see \link{agg_serie}.}
}
\value{
A data frame with two columns: Date and total volume discharge.
}
\description{
Converts mean monthly river discharge [m3/s] to total volume discharge [hm3].
}
\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Now assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )
               
# Now get mean monthly discharge
Qmm <- get_hydroMet(obj = guido, name = 'Qmm')[[1]]

# Get the monthly water volume
Qmm_vol <- Qmm_to_Dm(df = Qmm)

}
